/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class PerformanceListRecordDefinition
extends AbstractChartDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(PerformanceListRecordDefinition.class);
    private PredefinedTemplate layout;
    private IUniqueRecord record;
    private AlertElement alert;

    public PerformanceListRecordDefinition(String id) {
        super(id);
    }

    @Override
    public ChartCategorisation[] getCategorisation() {
        return EnumSet.allOf(ChartCategorisation.class).toArray(new ChartCategorisation[EnumSet.allOf(ChartCategorisation.class).size()]);
    }

    @Override
    public String getTitle() {
        return Messages.getString("SpreadSheet.alertdetail");
    }

    @Override
    public ChartSpecificDefinitions getSpecificType() {
        return null;
    }

    @Override
    public ChartType getType() {
        return ChartType.PERFORMANCE_RECORD;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("link");
    }

    @Override
    public List<ColumnDefinition> getAllColumnDefinitions() {
        return Collections.emptyList();
    }

    public static ChartSpecification createFor(PredefinedTemplate template, AlertElement element) {
        debug.enter("createFor");
        PerformanceListRecordDefinition defn = new PerformanceListRecordDefinition("PLRD");
        defn.layout = template;
        defn.alert = element;
        debug.exit("createFor", (Object)defn);
        return defn;
    }

    public IUniqueRecord getRecord() {
        return this.record;
    }

    public void setRecord(IUniqueRecord record) {
        this.record = record;
    }

    public PredefinedTemplate getLayout() {
        return this.layout;
    }

    public String getAlertDescription() {
        String desc = Messages.getString("PerformanceListRecordDefinition.No.associated.alert");
        if (this.alert != null) {
            desc = this.alert.getDescription();
        }
        return desc;
    }

    public AlertElement getAlert() {
        return this.alert;
    }
}

