/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.ChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.ui.QueryCache;
import java.util.ArrayList;
import java.util.List;

public class IntervalSpecificDefinitions
implements ChartSpecificDefinitions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(IntervalSpecificDefinitions.class);
    private List<PlotPoint> plotPoints;
    private List<ColumnDefinition> plotLines;
    private List<ColumnDefinition> altColumnLabels;
    private List<ColumnDefinition> renameColumnLabels;
    private List<ColumnDefinition> subLabel;
    private List<ColumnDefinition> subValue;
    private ColumnDefinition textValue;
    private String cheatSheet;
    private String alternative_presentation;
    private String merge_presentation;
    private int percentChart = -1;
    private String vrm;

    public IntervalSpecificDefinitions(List<PlotPoint> plotList1, List<ColumnDefinition> lineList, List<ColumnDefinition> altColumnLabels, List<ColumnDefinition> renameColumnLabels, List<ColumnDefinition> subColumnLabels, List<ColumnDefinition> subColumnValues, ColumnDefinition textValue, String cheatSheet, String alternative_presentation, String merge_presentation) {
        debug.enter("IntervalSpecificDefinitions");
        this.plotPoints = plotList1;
        this.plotLines = lineList;
        this.renameColumnLabels = renameColumnLabels;
        this.altColumnLabels = altColumnLabels;
        this.textValue = textValue;
        this.cheatSheet = cheatSheet;
        this.subLabel = subColumnLabels;
        this.subValue = subColumnValues;
        this.alternative_presentation = alternative_presentation;
        this.merge_presentation = merge_presentation;
        debug.exit("IntervalSpecificDefinitions");
    }

    @Override
    public ChartType getChartType() {
        return ChartType.INTERVAL_PLOT;
    }

    @Override
    public List<ColumnDefinition> getAllColumns() {
        ArrayList<ColumnDefinition> allDefns = new ArrayList<ColumnDefinition>();
        allDefns.addAll(this.plotLines);
        for (PlotPoint point : this.plotPoints) {
            allDefns.add(point.getPlotReference());
        }
        allDefns.addAll(this.altColumnLabels);
        if (this.textValue != null) {
            allDefns.add(this.textValue);
        }
        return allDefns;
    }

    @Override
    public int getDefaultIncrementWidth() {
        return 64;
    }

    @Override
    public int getDefaultWidth() {
        return 64;
    }

    public List<PlotPoint> getPlotPoints() {
        return this.plotPoints;
    }

    public List<ColumnDefinition> getPlotLines() {
        return this.plotLines;
    }

    public ColumnDefinition getTextValueColumn() {
        return this.textValue;
    }

    public List<ColumnDefinition> getAltColumnDefinitions() {
        return this.altColumnLabels;
    }

    public List<ColumnDefinition> getRenameColumnDefinitions() {
        return this.renameColumnLabels;
    }

    public List<ColumnDefinition> getSubColumnDefinitions() {
        return this.subLabel;
    }

    public List<ColumnDefinition> getSubColumnValueDefinitions() {
        return this.subValue;
    }

    public String getCheatSheet() {
        return this.cheatSheet;
    }

    public Presentation getMergePresentation() {
        if (StringUtil.hasContent((String)this.merge_presentation)) {
            return QueryCache.getInstance().getAppropriatePresentation(this.merge_presentation, this.vrm);
        }
        return null;
    }

    public boolean isPercentageChart() {
        if (this.percentChart == -1) {
            this.percentChart = 0;
            for (PlotPoint point : this.getPlotPoints()) {
                if (point.getPercentReference() == null) continue;
                this.percentChart = 1;
                break;
            }
        }
        return this.percentChart == 1;
    }

    public String getVRM() {
        return this.vrm;
    }

    public void setVRM(String vrm) {
        this.vrm = vrm;
    }

    public Presentation getAlternativePresentation() {
        Presentation pres = null;
        if (StringUtil.hasContent((String)this.alternative_presentation) && (pres = QueryCache.getInstance().getAppropriatePresentation(this.alternative_presentation, this.vrm)) != null) {
            PersistedChartDefinition chartReference = PersistedChartDefinition.getDefinition(pres);
            ((IntervalSpecificDefinitions)chartReference.getSpecificType()).setVRM(this.vrm);
        }
        return pres;
    }
}

