/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.pa.ui.Messages;
import java.util.ArrayList;
import java.util.EnumSet;

public enum ChartCategorisation {
    RESPONSETIME(Messages.getString("ChartCategorisation.RESPONSE_TIME"), Messages.getString("ChartCategorisation.RESPONSE_TIME_DESCRIPTION"), 3),
    SUSPEND(Messages.getString("ChartDefinition.MULTIROW_SUSPEND_ANALYSIS"), Messages.getString("ChartCategorisation.SUSPEND_DESCRIPTION"), 6),
    CPUTIME(Messages.getString("ChartCategorisation.CPU_TIME"), Messages.getString("ChartCategorisation.CPU_TIME_DESCRIPTION"), 2),
    THREADSAFE(Messages.getString("ChartCategorisation.THREADSAFE"), Messages.getString("ChartCategorisation.THREADSAFE_DESCRIPTION"), 1),
    RMI(Messages.getString("ChartCategorisation.RMI"), Messages.getString("ChartCategorisation.RMI_DESCRIPTION"), 11),
    STORAGE(Messages.getString("ChartDefinition.MULTIROW_STORAGE_ANALYSIS"), Messages.getString("ChartCategorisation.STORAGE_ANALYSIS_DESCRIPTION"), 4),
    FILEUSAGE(Messages.getString("ChartDefinition.MULTIROW_FILE_USAGE_ANALYSIS"), Messages.getString("ChartCategorisation.FILE_USAGE_DESCRIPTION"), 5),
    PROGRAMREQUEST(Messages.getString("ChartDefinition.MULTIROW_PROGRAMREQUEST_ANALYSIS"), Messages.getString("ChartCategorisation.PROGRAMREQUEST_ANALYSIS_DESCRIPTION"), 8),
    TRANSIENT_DATA(Messages.getString("ChartDefinition.MULTIROW_TRANSIENT_DATA_ANALYSIS"), Messages.getString("ChartCategorisation.TRANSIENT_DATA_ANALYSIS_DESCRIPTION"), 9),
    TEMPORARY_STORAGE(Messages.getString("ChartDefinition.MULTIROW_TEMPORARY_STORAGE_ANALYSIS"), Messages.getString("ChartCategorisation.TEMPORARY_STORAGE_ANALYSIS_DESCRIPTION"), 10),
    INTERVAL(Messages.getString("ChartDefinition.INTERVAL"), Messages.getString("ChartCategorisation.INTERVAL_DESCRIPTION"), 7);

    private String label;
    private String description;
    private int position;

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    private ChartCategorisation(String menuLabel, String description, int position) {
        this.label = menuLabel;
        this.description = description;
        this.position = position;
    }

    public static ChartCategorisation getByLabel(String label) {
        for (ChartCategorisation reference : EnumSet.allOf(ChartCategorisation.class)) {
            if (!reference.label.equals(label)) continue;
            return reference;
        }
        return null;
    }

    public static String[] getArray() {
        ArrayList<String> result = new ArrayList<String>();
        for (ChartCategorisation reference : EnumSet.allOf(ChartCategorisation.class)) {
            result.add(reference.getLabel());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getNumberedLabel() {
        return this.position + "." + this.label;
    }

    public static ChartCategorisation getByName(String label) {
        for (ChartCategorisation reference : EnumSet.allOf(ChartCategorisation.class)) {
            if (!reference.name().equals(label)) continue;
            return reference;
        }
        return null;
    }
}

