/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.AllRowsFilter;
import com.ibm.cics.pa.model.CSVDataProviderFilter;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import java.util.ArrayList;

public class SpecificRowsFilter
implements CSVDataProviderFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object[][] rows = null;
    private TreeElement root = null;
    protected GenericDataProvider dataStore;
    private String reference = null;
    private DataKeyElement[] keys = null;

    protected SpecificRowsFilter(GenericDataProvider dataStore) {
        this.dataStore = dataStore;
    }

    private SpecificRowsFilter(GenericDataProvider dataStore, IUniqueRecord[] records) {
        this(dataStore);
        ArrayList<DataKeyElement> elements = new ArrayList<DataKeyElement>();
        IUniqueRecord[] iUniqueRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            IUniqueRecord record = iUniqueRecordArray[n2];
            elements.add(record.getDataKey());
            ++n2;
        }
        this.keys = elements.toArray(new DataKeyElement[elements.size()]);
    }

    @Override
    public boolean accepts(Object[] dataRow) {
        int i = 0;
        while (i < this.getRows().length) {
            if (this.getRows()[i] == dataRow) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getReference() {
        if (this.reference == null) {
            this.reference = "";
            if (this.keys != null) {
                DataKeyElement[] dataKeyElementArray = this.keys;
                int n = this.keys.length;
                int n2 = 0;
                while (n2 < n) {
                    DataKeyElement element = dataKeyElementArray[n2];
                    this.reference = String.valueOf(this.reference) + "-" + element.getStatusBarText();
                    ++n2;
                }
            } else {
                this.reference = "";
                for (TreeElement element : this.populateElementArray()) {
                    this.reference = String.valueOf(this.reference) + "-" + element.getDataKey().getStatusBarText();
                }
            }
            this.reference = this.reference.replace(':', '-');
        }
        return this.reference;
    }

    @Override
    public String getId() {
        return String.valueOf(this.getReference().hashCode());
    }

    public static SpecificRowsFilter specificFilterFor(GenericDataProvider dataStore, IUniqueRecord[] records) {
        if (records != null) {
            return new SpecificRowsFilter(dataStore, records);
        }
        return new AllRowsFilter(dataStore);
    }

    public static SpecificRowsFilter specificFilterFor(GenericDataProvider dataStore) {
        return new AllRowsFilter(dataStore);
    }

    private ArrayList<TreeElement> populateElementArray() {
        ArrayList<TreeElement> elements = new ArrayList<TreeElement>();
        int j = 0;
        while (j < this.getRows().length) {
            Object[] children = this.getRoot().getChildren();
            int i = 0;
            while (i < children.length) {
                Object[] row = this.getRows()[j];
                if (row != null) {
                    this.findModel((TreeElement)children[i], elements, row);
                }
                ++i;
            }
            ++j;
        }
        return elements;
    }

    private void findModel(TreeElement startModel, ArrayList<TreeElement> elements, Object[] row) {
        if (row[startModel.getColumnRef()].equals(startModel.getLabel())) {
            if (startModel instanceof IUniqueRecord) {
                elements.add(startModel);
            } else {
                Object[] children = startModel.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.findModel((TreeElement)children[i], elements, row);
                    ++i;
                }
            }
        }
    }

    public synchronized Object[][] getRows() {
        if (this.rows == null) {
            int ctr = 0;
            ArrayList<IUniqueRecord> elements = new ArrayList<IUniqueRecord>();
            DataKeyElement[] dataKeyElementArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                DataKeyElement dataKey = dataKeyElementArray[n2];
                IUniqueRecord child = this.getRoot().getSpecificChild(dataKey);
                if (child != null) {
                    elements.add(child);
                    ++ctr;
                }
                ++n2;
            }
            this.rows = new Object[elements.size()][];
            ctr = 0;
            for (IUniqueRecord element : elements) {
                this.rows[ctr] = element.getRow();
                ++ctr;
            }
        }
        return this.rows;
    }

    private TreeElement getRoot() {
        if (this.root == null) {
            this.root = this.dataStore.getRootTreeElement();
        }
        return this.root;
    }
}

