/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.pa.model.ApplidTreeElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.IntervalsCaveat;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.TranTreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class SimpleTreeElement
implements IDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    public static final boolean isLinux = System.getProperty("os.name").equals("Linux");
    private ColumnDefinition type = null;
    private Object value = null;
    List<SimpleTreeElement> children = null;
    private SimpleTreeElement parent = null;
    DateCaveat dateCaveat;
    private static final ISchedulingRule mutexRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };

    protected SimpleTreeElement(SimpleTreeElement parent, ColumnDefinition type, Object value, DateCaveat dateToken) {
        this.parent = parent;
        this.type = type;
        this.value = value;
        this.dateCaveat = dateToken;
    }

    private SimpleTreeElement(DateCaveat dateToken) {
        this.dateCaveat = dateToken;
    }

    public static SimpleTreeElement createRoot(DateCaveat dateToken) {
        return new SimpleTreeElement(dateToken);
    }

    public SimpleTreeElement createChild(ColumnDefinition type, Object value, DateCaveat dateToken) {
        SimpleTreeElement child = null;
        if (this.children == null) {
            this.children = new ArrayList<SimpleTreeElement>();
        }
        if (value.toString().equals("00:00:00")) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"createChild", (Object)value);
        }
        child = type == ColumnDefinition.TRAN ? new TranTreeElement(this, type, value, dateToken) : (type == ColumnDefinition.APPLID ? new ApplidTreeElement(this, type, value, dateToken) : new SimpleTreeElement(this, type, value, dateToken));
        this.children.add(child);
        return child;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Object getValue() {
        return this.value;
    }

    public ColumnDefinition getType() {
        return this.type;
    }

    public SimpleTreeElement getParent() {
        return this.parent;
    }

    private DataProviderKey getCurrentDataProviderKey() {
        return PAContextTracker.getInstance().getStructureKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, final IElementCollector collector, final IProgressMonitor monitor) {
        if (this.children == null) {
            final boolean[] opComplete = new boolean[1];
            final ListeningEngine[] engines = new ListeningEngine[1];
            boolean[] blArray = opComplete;
            synchronized (opComplete) {
                engines[0] = this.retrieveChildren((SimpleTreeElement)object, collector, monitor, new EngineShell.EngineListener(){

                    public void dataAvailable(Collection<Object> items) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Complete: {
                                collector.add(SimpleTreeElement.this.children.toArray(), monitor);
                            }
                            case Cancelled: {
                                monitor.done();
                                collector.done();
                                opComplete[0] = true;
                                PAConnectionTracker.getInstance().removePAConnectionTrackerListener(engines[0]);
                                break;
                            }
                        }
                    }

                    public void notifyResultCount(int count) {
                    }
                });
                while (!opComplete[0]) {
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        monitor.setCanceled(true);
                    }
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        } else {
            collector.add(this.children.toArray(), monitor);
            collector.done();
            monitor.done();
        }
    }

    public ISchedulingRule getRule(Object object) {
        return mutexRule;
    }

    public boolean isContainer() {
        return this.getCurrentDataProviderKey().getNext(this.type) != null;
    }

    public Object[] getChildren(Object o) {
        if (this.children == null) {
            return new Object[0];
        }
        return this.children.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (this.value != null) {
            return this.value.toString();
        }
        return ".";
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public String getContentDescriptionLabel() {
        return this.isRoot() ? "" : String.valueOf(this.getParent().getContentDescriptionLabel()) + MessageFormat.format(Messages.getString("ContentDescription.TreeElement"), this.type.getLabel(null), DataTypeUtilities.getAsString(this.value));
    }

    public void applyConstraint(Selection selection) {
        if (this.isRoot()) {
            if (this.dateCaveat != null && !(this.dateCaveat instanceof NullRangeDateCaveat)) {
                selection.appendCondition(this.dateCaveat.getConstraint(null, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
            }
        } else {
            this.getParent().applyConstraint(selection);
            if (this.dateCaveat != null && !(this.dateCaveat instanceof NullRangeDateCaveat)) {
                selection.appendCondition(this.dateCaveat.getConstraint(null, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
            }
            selection.appendCondition(this.type.getDBColumnRef(), PAContextTracker.getInstance().getCurrentManifest().getName(), this.type.getType(), Comparator.EQ, new Object[]{this.value}, QueryElement.Predicate.AND, false);
        }
    }

    public Selection getAsSelection() {
        Selection selection = PresentationFactory.getInstance().createSelectAllForTable(PAContextTracker.getInstance().getShortTableReference(), ":schema");
        this.applyConstraint(selection);
        return selection;
    }

    private ListeningEngine retrieveChildren(final SimpleTreeElement element, final IElementCollector collector, final IProgressMonitor monitor, EngineShell.EngineListener engineListener) {
        ColumnDefinition nextColumn;
        ListeningEngine engine = null;
        if (this.children == null) {
            this.children = new ArrayList<SimpleTreeElement>();
        }
        if ((nextColumn = element.getCurrentDataProviderKey().getNext(element.getType())) != null && PAContextTracker.getInstance().getFullTableReference() != null) {
            engine = new ListeningEngine("com.ibm.cics.pa.connection", new RowProcessor(){

                public Map<String, Object> getParameterMap() {
                    return new HashMap<String, Object>();
                }

                public SelectionObject getSelectionObject() {
                    Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{PAContextTracker.getInstance().getShortTableReference()}, new String[]{":schema"});
                    selection.getSelect().setDistinct(true);
                    selection.getSelect().addSelectionColumn(nextColumn.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnReference.DataType.String, ColumnReference.Function.NONE);
                    if (!PAContextTracker.getInstance().getCurrentManifest().isPerformanceSummaryRecord() && IntervalsCaveat.getInstance().getClause() != null) {
                        selection.appendCondition((ConstraintElement)IntervalsCaveat.getInstance().getClause(), QueryElement.Predicate.AND);
                    }
                    selection.addOrderByCondition(nextColumn.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), nextColumn == ColumnDefinition.START || nextColumn == ColumnDefinition.START_DATE || nextColumn == ColumnDefinition.START_TIME ? Direction.DESC : Direction.ASC);
                    SimpleTreeElement.this.applyConstraint(selection);
                    return selection;
                }

                public Object processRow(ResultSet resultSet) {
                    try {
                        Object value = resultSet.getObject(nextColumn.getDBColumnRef());
                        if (value instanceof Time && value.toString().equals("00:00:00")) {
                            value = resultSet.getObject(nextColumn.getDBColumnRef());
                        }
                        SimpleTreeElement aChild = element.createChild(nextColumn, value, SimpleTreeElement.this.dateCaveat);
                        collector.add((Object)aChild, monitor);
                    }
                    catch (SQLException e) {
                        Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"startTreeQuery ", (Throwable)e);
                    }
                    return null;
                }
            });
            engine.addListener(engineListener);
            PAConnectionTracker.getInstance().addPAConnectionTrackerListener(engine);
            engine.setPageSize(10000);
            engine.start();
        }
        return engine;
    }

    public Image getImage() {
        return Activator.getDefault().getImage(this.type.getDBColumnRef());
    }

    public String toString() {
        return String.valueOf(this.parent == null ? "" : this.parent.toString()) + (this.value == null ? "" : this.value.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    class ListeningEngine
    extends Engine
    implements PAConnectionListener {
        public ListeningEngine(String connectionCategory, RowProcessor irp) {
            super(connectionCategory, irp);
        }

        @Override
        public void disconnected() {
        }

        @Override
        public void connected(PAConnectionListener.Era era) {
        }

        @Override
        public void disconnecting() {
            this.cancel();
        }
    }

    class RequestSchedulingRule
    implements ISchedulingRule {
        RequestSchedulingRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

