/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.pa.model.CSVDataProviderFilter;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Pattern;

public class SQLStyleCSVFilter
implements CSVDataProviderFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SQLStyleCSVFilter.class);
    private List<FilterElement> elements;
    private GenericDataProvider provider;

    private SQLStyleCSVFilter(GenericDataProvider provider, List<FilterElement> elements) {
        this.elements = elements;
        this.provider = provider;
    }

    @Override
    public boolean accepts(Object[] dataRow) {
        for (FilterElement element : this.elements) {
            ColumnDefinition defn = (ColumnDefinition)element.getColumn();
            int pos = this.provider.getColumnPosition(defn);
            Object comparisonValue = dataRow[pos];
            element.getOperator();
            try {
                Object filterValue = DataTypeUtilities.assignAppropriateCSVBasedObject(defn, element.getValue());
                if (this.doComparison(defn, element.getOperator(), filterValue, comparisonValue)) continue;
                return false;
            }
            catch (ParseException e) {
                debug.error("accepts", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public String getReference() {
        StringBuffer buffer = new StringBuffer();
        for (FilterElement element : this.elements) {
            buffer.append(element.toString());
            buffer.append(',');
        }
        return buffer.toString();
    }

    @Override
    public String getId() {
        return String.valueOf(this.getReference().hashCode());
    }

    public static SQLStyleCSVFilter getFilterFor(GenericDataProvider provider, List<FilterElement> elements) {
        return new SQLStyleCSVFilter(provider, elements);
    }

    private boolean doComparison(ColumnDefinition defn, String attribute, Object filterValue, Object value) {
        if (attribute.trim().equals("=") && defn.getType() == ColumnReference.DataType.String) {
            if (((String)filterValue).indexOf(37) > -1) {
                ((String)filterValue).replace('%', '*');
            }
            if (((String)filterValue).indexOf(42) > -1) {
                return Pattern.matches(DataTypeUtilities.wildcardToRegexp((String)filterValue), (String)value);
            }
            return DataTypeUtilities.compare(defn, 128, filterValue, value) == 0;
        }
        if (attribute.trim().equals("=")) {
            return DataTypeUtilities.compare(defn, 128, filterValue, value) == 0;
        }
        if (attribute.trim().equals("!=")) {
            if (((String)filterValue).indexOf(37) > -1) {
                ((String)filterValue).replace('%', '*');
            }
            if (((String)filterValue).indexOf(42) > -1) {
                return !Pattern.matches(DataTypeUtilities.wildcardToRegexp((String)filterValue), (String)value);
            }
            return DataTypeUtilities.compare(defn, 128, filterValue, value) != 0;
        }
        if (attribute.trim().equals(">")) {
            return DataTypeUtilities.compare(defn, 128, filterValue, value) < 0;
        }
        if (attribute.trim().equals(">=")) {
            return DataTypeUtilities.compare(defn, 128, filterValue, value) < 1;
        }
        if (attribute.trim().equals("<")) {
            return DataTypeUtilities.compare(defn, 128, filterValue, value) > 0;
        }
        if (attribute.trim().equals("<=")) {
            return DataTypeUtilities.compare(defn, 128, filterValue, value) > -1;
        }
        return false;
    }
}

