/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.PBKey;
import com.ibm.cics.pa.model.ProfilerBucket;
import com.ibm.cics.pa.model.definitions.ProfilerLayout;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.views.profiler.ProfileView;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ProfilerPairing {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ProfilerPairing.class);
    private Date baseDate;
    private Time baseTime;
    private Date variantDate;
    private Time variantTime;
    private ProfilerBucket baseBucket = ProfilerBucket.getBaseInstance();
    private ProfilerBucket variantBucket = ProfilerBucket.getVariantInstance();
    private Set<String> status = new HashSet<String>();
    private ProfileView view;
    private static ProfilerPairing instance = null;

    private ProfilerPairing() {
    }

    public static ProfilerPairing createProfilePairing(String baseApplid, String baseTransaction, Date baseDate, Time baseTime, String variantApplid, String variantTransaction, Date variantDate, Time variantTime) {
        debug.enter("createProfilePairing");
        if (instance == null) {
            instance = new ProfilerPairing();
            ProfilerPairing.instance.status.add(ProfilerPairing.class.getName());
        }
        ProfilerPairing.instance.baseDate = baseDate;
        ProfilerPairing.instance.baseTime = baseTime;
        ProfilerPairing.instance.variantDate = variantDate;
        ProfilerPairing.instance.variantTime = variantTime;
        ProfilerPairing.instance.baseBucket.createFor(baseApplid, baseTransaction);
        ProfilerPairing.instance.variantBucket.createFor(variantApplid, variantTransaction);
        debug.exit("createProfilePairing", (Object)instance.toString());
        return instance;
    }

    public static boolean pairingInitialised() {
        return instance != null;
    }

    public ProfilerBucket getBaseBucket() {
        return this.baseBucket;
    }

    public ProfilerBucket getVariantBucket() {
        return this.variantBucket;
    }

    public String getDescription() {
        return MessageFormat.format(Messages.getString("Profiler_description"), this.baseBucket.getApplid(), this.baseBucket.getTransaction(), this.variantBucket.getApplid(), this.variantBucket.getTransaction());
    }

    public boolean isPopulated() {
        return this.status.isEmpty();
    }

    public synchronized void initialiseStatus() {
        this.status = new HashSet<String>();
    }

    public synchronized void startStatus(String jobString) {
        debug.enter("startStatus", (Object)jobString);
        this.status.add(jobString);
        debug.exit("startStatus", (Object)this.status.size());
    }

    public synchronized void stopStatus(String jobString) {
        debug.enter("stopStatus", (Object)jobString);
        this.status.remove(jobString);
        if (this.status.isEmpty() && this.view != null) {
            this.view.setContent(this);
        }
        debug.exit("stopStatus", (Object)this.status.size());
    }

    public Date getBaseDate() {
        return this.baseDate;
    }

    public Time getBaseTime() {
        return this.baseTime;
    }

    public PBKey getBaseDatum() {
        if (this.baseDate == null) {
            if (this.getBaseBucket().getSize() > 0) {
                PBKey key = this.getBaseBucket().getKeyAtLocation(this.getBaseBucket().getSize() / 2);
                this.baseDate = key.getDate();
                this.baseTime = key.getTime();
                return key;
            }
            return null;
        }
        return new PBKey(this.baseDate, this.baseTime);
    }

    public int getBaseDisplacement() {
        PBKey datum = this.getBaseDatum();
        int i = 0;
        while (i < this.getBaseTotal()) {
            if (this.baseBucket.getAllKeys()[i].equals(datum)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getBaseTotal() {
        return this.baseBucket.getSize();
    }

    public PBKey getVariantDatum() {
        if (this.variantDate == null) {
            if (this.getBaseBucket().getSize() > 0) {
                PBKey key = this.getVariantBucket().getKeyAtLocation(this.getVariantBucket().getSize() / 2);
                this.variantDate = key.getDate();
                this.variantTime = key.getTime();
                return key;
            }
            return null;
        }
        return new PBKey(this.variantDate, this.variantTime);
    }

    public int getVariantDisplacement() {
        PBKey datum = this.getVariantDatum();
        int i = 0;
        while (i < this.variantBucket.getSize()) {
            if (this.variantBucket.getAllKeys()[i].equals(datum)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getVariantTotal() {
        return this.variantBucket.getSize();
    }

    public Date getVariantDate() {
        return this.variantDate;
    }

    public Time getVariantTime() {
        return this.variantTime;
    }

    public static ProfilerPairing getEmptyPairing() {
        Date aDate = new Date();
        ProfilerPairing pp = ProfilerPairing.createProfilePairing("APPLID", "TRAN", aDate, new Time(aDate.getTime()), "APPLID", "TRAN", aDate, new Time(aDate.getTime()));
        pp.startStatus("Touch");
        pp.stopStatus("Touch");
        return pp;
    }

    public double getMaximumValue(int position) {
        return Math.max(this.baseBucket.getMaximumValue(position), this.variantBucket.getMaximumValue(position));
    }

    public double getMaximumValue(ProfilerLayout layout) {
        return Math.max(this.baseBucket.getMaximumValue(layout), this.variantBucket.getMaximumValue(layout));
    }

    public void adviseWhenPopulated(ProfileView profileView) {
        this.view = profileView;
        if (this.status.isEmpty()) {
            this.view.setContent(this);
        }
    }
}

