/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class PreRangeDateCaveat
extends DateCaveat {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected PreRangeDateCaveat(Date date) {
        super(date);
    }

    @Override
    public String getAsWhereClause(String prepend) {
        Time sqlTime = new Time(this.startdate.getTime());
        java.sql.Date sqlDate = new java.sql.Date(this.startdate.getTime());
        return String.valueOf(prepend) + "((" + ColumnDefinition.START_DATE.getDBColumnRef() + " < '" + sqlDate.toString() + "') OR ((" + ColumnDefinition.START_DATE.getDBColumnRef() + " = '" + sqlDate.toString() + "') AND (" + ColumnDefinition.START_TIME.getDBColumnRef() + " <= '" + sqlTime.toString() + "'))) ";
    }

    @Override
    public ConstraintElement getConstraint(String databaseTable, boolean isTimestamp) {
        Clause constraint = null;
        if (isTimestamp) {
            Timestamp sqlTimestamp = new Timestamp(this.startdate.getTime());
            constraint = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.START.getDBColumnRef(), databaseTable, ColumnReference.DataType.Timestamp, Comparator.LE, new Object[]{sqlTimestamp}, false);
        } else {
            Time sqlTime = new Time(this.startdate.getTime());
            java.sql.Date sqlDate = new java.sql.Date(this.startdate.getTime());
            constraint = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.START_TIME.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.LE, new Object[]{sqlTime}, false);
            constraint = constraint.appendCondition(ColumnDefinition.START_DATE.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.EQ, new Object[]{sqlDate}, QueryElement.Predicate.AND, false);
            constraint = constraint.appendCondition(ColumnDefinition.START_DATE.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.LT, new Object[]{sqlDate}, QueryElement.Predicate.OR, false);
        }
        return constraint;
    }

    @Override
    public String getLabel() {
        return String.valueOf(Messages.getString("PreRangeDateCaveat_Prior")) + sdf.format(this.startdate);
    }

    @Override
    public long getEndTimeInMillis() {
        return this.getStartTimeInMillis();
    }
}

