/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.GraphModel;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.ChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.HistogramChartSpecificDefinitions;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.figures.SelectableColumn;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class Histogram
extends GraphModel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HashMap<IUniqueRecord, SelectableColumn> arrItems = new HashMap();
    public int incrementWidth;
    public Object[] itemIds;
    public Object[] itemLabels;
    private double maxValueYAxis1;
    private double maxValueYAxis2;
    private int numberOfItems;
    private String secondaryAxisLabel;
    public double secondaryScalingFactor;
    private String tertiaryAxisLabel;
    private ChartSpecificDefinitions specificChartReference;
    private IUniqueRecord initialItem;

    public Histogram(ChartSpecification chartReference, GenericDataProvider dataStore, IUniqueRecord record, List<ChartSelectable> primaryColumns) {
        super(chartReference, dataStore);
        this.initialise(primaryColumns);
        this.initialItem = record;
    }

    private void calculateMaxMinValues2() {
        this.maxValueYAxis1 = 0.0;
        this.maxValueYAxis2 = 0.0;
        int i = 0;
        while (i < this.primaryColumns.size()) {
            if (this.maxValueYAxis1 < ((ChartSelectable)((Object)this.primaryColumns.get(i))).getTotalPrimary()) {
                this.maxValueYAxis1 = ((ChartSelectable)((Object)this.primaryColumns.get(i))).getTotalPrimary();
            }
            if (this.maxValueYAxis2 < ((ChartSelectable)((Object)this.primaryColumns.get(i))).getTotalSecondary()) {
                this.maxValueYAxis2 = ((ChartSelectable)((Object)this.primaryColumns.get(i))).getTotalSecondary();
            }
            ++i;
        }
        this.maxValueYAxis1 *= 1.05;
        this.maxValueYAxis2 *= 1.05;
        if (!this.hasDualScaling()) {
            this.maxValueYAxis1 = Math.max(this.maxValueYAxis1, this.maxValueYAxis2);
        }
    }

    private void estimateWidth2() {
        this.numberOfItems = this.primaryColumns.size();
        this.calculateMaxMinValues2();
        if (this.primaryColumns.size() > 0 && ((ChartSelectable)((Object)this.primaryColumns.get(0))).isTwinAxis()) {
            this.incrementWidth += this.getDefaultBarWidth();
        }
        if (!this.isCompact() && this.numberOfItems > 0 && this.numberOfItems * this.incrementWidth + this.getLeftMargin() + this.getRightMargin() < 750) {
            int factor = (750 - (this.numberOfItems * this.incrementWidth + this.getLeftMargin() + this.getRightMargin())) / this.numberOfItems;
            this.incrementWidth += factor;
        }
        this.setPreferrerdPixelWidth(Math.max(this.numberOfItems * this.getIncrementWidth() + this.getLeftMargin() + this.getRightMargin(), 750));
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("histogram");
    }

    public int getIncrementWidth() {
        return this.incrementWidth;
    }

    public Object[] getItemLabels() {
        return this.itemLabels;
    }

    public double getMaxValueYAxis1() {
        return this.hasDualScaling() ? Math.max(this.maxValueYAxis1, this.maxValueYAxis2) : this.maxValueYAxis1;
    }

    public double getMaxValueYAxis2() {
        return this.maxValueYAxis2;
    }

    public boolean isTwinAxis() {
        return this.primaryColumns != null && this.primaryColumns.size() > 0 && ((ChartSelectable)((Object)this.primaryColumns.get(0))).isTwinAxis();
    }

    public boolean hasDualScaling() {
        return this.isTwinAxis() && this.getTertiaryLabel() != null;
    }

    public void setIncrementWidth(int incrementWidth) {
        if (!this.specificChartReference.getChartType().equals((Object)ChartType.COMPACT_HISTOGRAM)) {
            this.incrementWidth = incrementWidth;
        }
    }

    @Override
    public int getDefaultBarWidth() {
        return this.specificChartReference.getDefaultWidth();
    }

    @Override
    public int getDefaultIncrementWidth() {
        return this.specificChartReference.getDefaultIncrementWidth();
    }

    public String getTertiaryLabel() {
        return this.tertiaryAxisLabel;
    }

    public String getSecondaryLabel() {
        return this.secondaryAxisLabel;
    }

    public void setPreferrerdPixelWidth(int preferrerdPixelWidth) {
        this.preferrerdPixelWidth = preferrerdPixelWidth;
    }

    public HashMap<IUniqueRecord, SelectableColumn> getColumnMapping() {
        return this.arrItems;
    }

    @Override
    public void remove() {
        super.remove();
        this.arrItems = new HashMap();
        this.primaryColumns = null;
        this.itemIds = null;
        this.itemLabels = null;
    }

    @Override
    public void initialise(List<ChartSelectable> revisedPrimaryColumns) {
        this.primaryColumns = revisedPrimaryColumns;
        this.primaryDescription = ((HistogramChartSpecificDefinitions)this.getChartReference().getSpecificType()).getPrimaryDescription();
        this.setChartId(String.valueOf(this.getDataProvider().getId()) + "-" + this.getChartReference().name());
        references.put(this.getChartId(), this);
        this.itemLabels = new Object[this.primaryColumns.size()];
        int ctr = 0;
        for (ChartSelectable column : this.primaryColumns) {
            column.setModel(this);
            this.arrItems.put(column.getUniqueRecord(), (SelectableColumn)column);
            this.itemLabels[ctr] = ((HistogramChartSpecificDefinitions)this.getChartReference().getSpecificType()).getPkg().resolve(this.getDataProvider().getColumnDefinitions(), column.getDataRow());
            ++ctr;
        }
        this.specificChartReference = this.getChartReference().getSpecificType();
        this.secondaryAxisLabel = ((HistogramChartSpecificDefinitions)this.getChartReference().getSpecificType()).getAxisy1();
        this.tertiaryAxisLabel = ((HistogramChartSpecificDefinitions)this.getChartReference().getSpecificType()).getAxisy2();
        this.incrementWidth = this.getDefaultIncrementWidth();
        this.barWidth = this.getDefaultBarWidth();
        this.estimateWidth2();
    }

    public IUniqueRecord getInitialItem() {
        return this.initialItem;
    }
}

