/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DataKeyElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DataProviderKey structure;
    private Object[] values;
    public static final String DATA_ELEMENTS = "DataElements";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");

    public static DataKeyElement createDataKey(DataProviderKey structure, Object[] values) {
        return new DataKeyElement(structure, values);
    }

    public static int getAggregatedHashcode(DataKeyElement[] dataElementKeys) {
        Debug.enter((Logger)logger, (String)DataKeyElement.class.getName(), (String)"getAggregatedHashcode");
        String hash = "";
        if (dataElementKeys != null) {
            DataKeyElement[] dataKeyElementArray = dataElementKeys;
            int n = dataElementKeys.length;
            int n2 = 0;
            while (n2 < n) {
                DataKeyElement key = dataKeyElementArray[n2];
                hash = String.valueOf(hash) + key.getFullDescriptiveReference();
                ++n2;
            }
        }
        Debug.exit((Logger)logger, (String)DataKeyElement.class.getName(), (String)"getAggregatedHashcode", (Object)hash);
        return hash.hashCode();
    }

    public static DataKeyElement createDataKey(GenericDataProvider dataSource, Object[] row) {
        DataProviderKey key = dataSource.getDataProviderKey();
        int[] positions = dataSource.getColumnPositions(key);
        Object[] values = new Object[positions.length];
        int i = 0;
        while (i < positions.length) {
            values[i] = row[positions[i]];
            ++i;
        }
        return new DataKeyElement(key, values);
    }

    public DataKeyElement cloneOnColumns(DataProviderKey dataProviderKey) {
        Object[] values0 = new Object[dataProviderKey.getColumnDefinitions().length];
        int i = 0;
        while (i < dataProviderKey.getColumnDefinitions().length) {
            int j = 0;
            while (j < this.structure.getColumnDefinitions().length) {
                if (dataProviderKey.getColumnDefinitions()[i].equals(this.structure.getColumnDefinitions()[j])) {
                    values0[i] = this.values[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return DataKeyElement.createDataKey(dataProviderKey, values0);
    }

    public DataKeyElement cloneOnColumns(ColumnDefinition[] columns) {
        Object[] values0 = new Object[columns.length];
        int i = 0;
        while (i < columns.length) {
            int j = 0;
            while (j < this.structure.getColumnDefinitions().length) {
                if (columns[i].equals(this.structure.getColumnDefinitions()[j])) {
                    values0[i] = this.values[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return DataKeyElement.createDataKey(this.structure, values0);
    }

    public static DataKeyElement createRootDataKey(GenericDataProvider dataSource) {
        return new DataKeyElement(dataSource.getDataProviderKey());
    }

    private DataKeyElement(DataProviderKey structure) {
        this.structure = structure;
        this.values = new Object[0];
    }

    private DataKeyElement(DataProviderKey structure, Object[] values) {
        this.structure = structure;
        this.values = values;
    }

    public boolean equals(Object comp) {
        return comp instanceof DataKeyElement && this.getFullElementReference().equals(((DataKeyElement)comp).getFullElementReference());
    }

    public String getColumnDescriptiveFullReference() {
        return this.getElementReference(true);
    }

    private String getElementReference(boolean withTypeLabelling) {
        String shortRef = "";
        int i = 0;
        while (i < this.values.length) {
            if (shortRef.length() > 0) {
                shortRef = String.valueOf(shortRef) + ", ";
            }
            if (withTypeLabelling) {
                shortRef = String.valueOf(shortRef) + this.structure.getColumnDefinitions()[i].getLabel(null) + "=";
            }
            shortRef = String.valueOf(shortRef) + DataTypeUtilities.getAsString(this.values[i]);
            ++i;
        }
        return shortRef;
    }

    public String getFullDescriptiveReference() {
        return this.getElementReference(false);
    }

    public String getFullElementReference() {
        return String.valueOf(this.structure.name()) + "/" + this.getFullDescriptiveReference();
    }

    public LinkedHashMap<Integer, Object> getReferenceMapFor(GenericDataProvider dataSource) {
        LinkedHashMap<Integer, Object> reference = new LinkedHashMap<Integer, Object>();
        if (dataSource != null) {
            int[] positions = dataSource.getColumnPositions(this.structure);
            int i = 0;
            while (i < this.values.length) {
                reference.put(new Integer(positions[i]), this.values[i]);
                ++i;
            }
        }
        return reference;
    }

    public Map<ColumnDefinition, Object> getReferenceMapping() {
        HashMap<ColumnDefinition, Object> reference = new HashMap<ColumnDefinition, Object>();
        int i = 0;
        while (i < this.values.length) {
            reference.put(this.structure.getColumnDefinitions()[i], this.values[i]);
            ++i;
        }
        return reference;
    }

    public String getStatusBarText() {
        String reference = "";
        int i = 0;
        while (i < this.values.length) {
            reference = String.valueOf(reference) + "/" + DataTypeUtilities.getAsString(this.values[i]);
            ++i;
        }
        return reference;
    }

    public String getTreeLeafLabel() {
        return DataTypeUtilities.getAsString(this.values[this.values.length - 1]);
    }

    public boolean isLeaf() {
        return this.values.length == this.structure.getColumnDefinitions().length;
    }

    public boolean isParentOf(DataKeyElement sub) {
        boolean res = true;
        if (this.values.length > sub.values.length) {
            return false;
        }
        int i = 0;
        while (i < this.values.length) {
            res = this.values[i].equals(sub.values[i]);
            ++i;
        }
        return res;
    }

    public boolean thatsOneOfMine(Object[] row, int[] positions) {
        boolean result = true;
        int i = 0;
        while (i < this.values.length) {
            result = row[positions[i]].equals(this.values[i]);
            if (!result) break;
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.getFullDescriptiveReference();
    }

    public String[] getLabels() {
        String[] results = new String[this.structure.getColumnDefinitions().length];
        int i = 0;
        while (i < results.length) {
            results[i] = this.structure.getColumnDefinitions()[i].getLabel(null);
            ++i;
        }
        return results;
    }

    public Object[] getValues() {
        return this.values;
    }

    public Date getACombinedDateReference() {
        Date resDate = new Date(0L);
        if (this.structure.contains(ColumnDefinition.START_DATE) && this.structure.contains(ColumnDefinition.START_TIME)) {
            if (this.values[0] instanceof Date && this.values[1] instanceof Time) {
                return DataTypeUtilities.combineDateTime((Date)this.values[0], (Time)this.values[1]);
            }
            try {
                resDate = new Date(new SimpleDateFormat().parse(String.valueOf((String)this.values[0]) + " " + this.values[1]).getTime());
            }
            catch (ParseException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"getDateRangeCovered", (Throwable)e);
            }
        }
        return resDate;
    }

    public boolean isPerformanceSummary() {
        return this.structure == DataProviderKey.STARTTIME_APPLID_TRAN;
    }

    public boolean isAppPerformanceSummary() {
        return this.structure == DataProviderKey.STARTTIME_APPLICATION;
    }

    public boolean isPerformanceList() {
        return this.structure == DataProviderKey.PERFORMANCE_LIST;
    }

    public boolean isPerformanceAlert() {
        return this.structure == DataProviderKey.PERFORMANCE_ALERT;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

