/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.ExplorerViewModel;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;

public class CommonTree {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Pattern keyValueDivider = Pattern.compile("=");
    protected static final Pattern entryDivider = Pattern.compile("/");
    protected Map<Object, TreeElement> children = new LinkedHashMap<Object, TreeElement>();
    protected GenericDataProvider source;
    protected TreeElement parent;
    protected int columnRef = -9;
    protected ColumnDefinition column;
    protected DataProviderKey structureKey;
    protected DataKeyElement[] childElements = null;
    protected Object label;
    protected DataKeyElement dataKey;

    public boolean equals(Object comp) {
        if (comp instanceof CommonTree) {
            return this.getDataKey().equals(((CommonTree)comp).getDataKey());
        }
        return false;
    }

    public Object[] getChildren() {
        return this.children.values().toArray(new ExplorerViewModel[this.children.size()]);
    }

    public ColumnDefinition getColumn() {
        return this.column;
    }

    public int getColumnRef() {
        if (this.columnRef == -9) {
            this.columnRef = this.getSourceProvider().getColumnPosition(this.column);
        }
        return this.columnRef;
    }

    public DataKeyElement getDataKey() {
        if (this.dataKey == null) {
            if (this.isRoot()) {
                this.dataKey = DataKeyElement.createRootDataKey(this.getSourceProvider());
            } else {
                ArrayList<Object> reference = new ArrayList<Object>();
                reference.add(this.getLabel());
                TreeElement ancestor = this.getParent();
                while (ancestor != null && !ancestor.isRoot()) {
                    reference.add(ancestor.getLabel());
                    ancestor = ancestor.getParent();
                }
                Collections.reverse(reference);
                this.dataKey = DataKeyElement.createDataKey(this.getSourceProvider().getDataProviderKey(), reference.toArray());
            }
        }
        return this.dataKey;
    }

    public DataProviderKey getDataProviderKey() {
        return this.getSourceProvider().getDataProviderKey();
    }

    public String[] getHeaders() {
        return this.getSourceProvider().getHeaders();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (((TreeElement)object).getColumn() == ColumnDefinition.TRAN) {
            return Activator.getDefault().getImageDescriptor(Activator.IMGD_TRAN);
        }
        if (((TreeElement)object).getColumn() == ColumnDefinition.APPLID) {
            return Activator.getDefault().getImageDescriptor(Activator.IMGD_REGION);
        }
        if (((TreeElement)object).getColumn() == ColumnDefinition.START_DATE) {
            return Activator.getDefault().getImageDescriptor(Activator.IMGD_DATE);
        }
        if (((TreeElement)object).getColumn() == ColumnDefinition.START_TIME) {
            return Activator.getDefault().getImageDescriptor(Activator.IMGD_WAITING);
        }
        return null;
    }

    public Object getLabel() {
        return this.label;
    }

    public String getLabel(Object o) {
        if (this.isRoot()) {
            return "Root";
        }
        return DataTypeUtilities.getAsString(o);
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public String getTreeLabel() {
        return this.getDataKey().getTreeLeafLabel();
    }

    public GenericDataProvider getSourceProvider() {
        if (this.isRoot() || this.source != null) {
            return this.source;
        }
        if (this.parent != null) {
            return this.parent.getSourceProvider();
        }
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean isRoot() {
        return this.columnRef == -1;
    }

    public IUniqueRecord getSpecificChild(DataKeyElement dataKey) {
        Object[] objectArray = this.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (((TreeElement)child).isParentOf(dataKey)) {
                if (child instanceof IUniqueRecord && ((IUniqueRecord)child).getDataKey().equals(dataKey)) {
                    return (IUniqueRecord)child;
                }
                return ((TreeElement)child).getSpecificChild(dataKey);
            }
            ++n2;
        }
        return null;
    }

    public boolean isParentOf(DataKeyElement dataKey) {
        return this.getDataKey().isParentOf(dataKey);
    }

    public void setParent(TreeElement parent) {
        this.parent = parent;
    }

    public String toString() {
        if (this.dataKey != null) {
            return String.valueOf(this.getClass().getName()) + this.getDataKey().getFullDescriptiveReference();
        }
        return this.getClass().getName();
    }

    public ArrayList<IUniqueRecord> getAllLeafDescendents() {
        ArrayList<IUniqueRecord> collection = new ArrayList<IUniqueRecord>();
        if (this instanceof IUniqueRecord) {
            collection.add((IUniqueRecord)((Object)this));
        } else {
            Object[] objectArray = this.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child1 = objectArray[n2];
                TreeElement child0 = (TreeElement)child1;
                if (child0 instanceof IUniqueRecord) {
                    collection.add((IUniqueRecord)child0);
                } else {
                    collection.addAll(child0.getAllLeafDescendents());
                }
                ++n2;
            }
        }
        return collection;
    }

    public LinkedHashMap<Integer, Object> getReferenceMap() {
        return this.getDataKey().getReferenceMapFor(this.getSourceProvider());
    }

    public Map<ColumnDefinition, Object> getReferenceMapping() {
        return this.getDataKey().getReferenceMapping();
    }

    public String getReference() {
        return this.getDataKey().getStatusBarText();
    }

    public String getRelativeText() {
        return this.getDataKey().getStatusBarText().replace(':', '.');
    }

    public int hashCode() {
        return super.hashCode();
    }
}

