/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ColumnDefinitionHelper;
import com.ibm.cics.pa.ui.Activator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Column {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final ColorRegistry colourRegistry = Activator.getDefault().getColorRegistry();
    private static final ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
    private ColumnDefinition defn = null;
    private static Map<ColumnDefinition, Column> instances = new HashMap<ColumnDefinition, Column>();

    public Column(ColumnDefinition defn) {
        this.defn = defn;
    }

    public ColumnDefinition getColumnDefinition() {
        return this.defn;
    }

    public static Column getFor(ColumnDefinition defn) {
        if (!instances.keySet().contains(defn)) {
            instances.put(defn, new Column(defn));
        }
        return instances.get(defn);
    }

    public boolean hasChildren() {
        return ColumnDefinitionHelper.definitionHasChildren(this.defn);
    }

    public Object[] getChildren() {
        ArrayList<Column> cols = new ArrayList<Column>();
        ColumnDefinition[] defns = ColumnDefinitionHelper.getDefinitionChildren(this.defn);
        if (defns != null) {
            ColumnDefinition[] columnDefinitionArray = defns;
            int n = defns.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn1 = columnDefinitionArray[n2];
                cols.add(Column.getFor(defn1));
                ++n2;
            }
        }
        return cols.toArray();
    }

    public Column[] getParents() {
        ColumnDefinition[] parents;
        ArrayList<Column> columns = new ArrayList<Column>();
        ColumnDefinition[] columnDefinitionArray = parents = ColumnDefinitionHelper.getDefinitionParent(this.defn);
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition columnDefinition = columnDefinitionArray[n2];
            columns.add(Column.getFor(columnDefinition));
            ++n2;
        }
        return columns.toArray(new Column[columns.size()]);
    }

    public Color getColor() {
        if (!colourRegistry.hasValueFor(this.defn.getDBColumnRef())) {
            colourRegistry.put(this.defn.getDBColumnRef(), ColumnDefinitionHelper.definitionRGB(this.defn));
        }
        return colourRegistry.get(this.defn.getDBColumnRef());
    }

    public void setColor(RGB rgb) {
        ColumnDefinitionHelper.setDefinitionRGB(rgb, this.defn);
        colourRegistry.put(this.defn.getDBColumnRef(), rgb);
        imageRegistry.remove(this.defn.getDBColumnRef());
        this.getImage();
    }

    public void resetColorToDefault() {
        RGB rgb = ColumnDefinitionHelper.resetDefinitionRGB(this.defn);
        colourRegistry.put(this.defn.getDBColumnRef(), rgb);
        imageRegistry.remove(this.defn.getDBColumnRef());
    }

    public Image getImage() {
        Image image1 = Activator.getDefault().getImage(this.defn.getDBColumnRef());
        if (image1 == null) {
            image1 = imageRegistry.get(this.defn.getDBColumnRef());
        }
        if (image1 == null) {
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Column.this.getImage();
                    }
                });
            } else {
                image1 = Column.createImage(Display.getCurrent(), this.getColor());
                imageRegistry.put(this.defn.getDBColumnRef(), image1);
            }
        } else if (image1.isDisposed()) {
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Column.this.getImage();
                    }
                });
            } else {
                imageRegistry.remove(this.defn.getDBColumnRef());
                image1 = Column.createImage(Display.getCurrent(), this.getColor());
                imageRegistry.put(this.defn.getDBColumnRef(), image1);
            }
        }
        return image1;
    }

    public String getLabel() {
        return this.defn.getLabel(null);
    }

    public String label() {
        return this.defn.label();
    }

    public static Image createImage(Display display, Color colorRef) {
        Image image = new Image((Device)display, 17, 17);
        GC gc = new GC((Drawable)image);
        gc.setBackground(display.getSystemColor(22));
        gc.setForeground(display.getSystemColor(22));
        gc.fillRectangle(0, 0, 17, 17);
        gc.setForeground(display.getSystemColor(21));
        gc.setBackground(colorRef);
        gc.setAlpha(150);
        gc.drawRectangle(2, 2, 11, 11);
        gc.fillRectangle(3, 3, 10, 10);
        gc.dispose();
        return image;
    }
}

