/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.CSVDataExtract;
import com.ibm.cics.pa.model.CSVDataRestrictionFilter;
import com.ibm.cics.pa.model.CSVFile;
import com.ibm.cics.pa.model.ExplorerViewModel;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.SQLStyleCSVFilter;
import com.ibm.cics.pa.model.SpecificRowsFilter;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.figures.SelectableColumn;
import com.ibm.cics.pa.ui.remote.DBQueryFactoryCustomer;
import com.ibm.cics.pa.ui.remote.HierarchicalRemoteElement;
import com.ibm.cics.pa.ui.remote.RemoteConnectionProvider;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public abstract class ChartingFile
implements GenericDataProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String RESTRICTIVE_FILTERS = "Restrictive_Filter";
    public static final String SOURCE = "Source_File";
    public static final String SPECIFIC_FILTERS = "Specific_Filter";
    public static final String CSV_FILE = "CSV_File";
    public static final String SORT_COLUMN = "SortColumn";
    public static final String SORT_COLUMN_DIRECTION = "SortDirection";
    protected static Map<String, GenericDataProvider> references2 = new HashMap<String, GenericDataProvider>();
    protected boolean valid = true;
    protected boolean corrupted = false;
    protected String reference2;
    protected TreeElement explorerViewModel = null;
    protected Object[][] data = null;
    protected ArrayList<IUniqueRecord> allresults = new ArrayList();
    protected ChartingFile thisOwner = this;
    protected String tabName = null;
    protected boolean isDisposed = false;
    protected int useCount = 0;
    protected IResourceChangeListener resourceListener = null;
    public static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");

    protected ChartingFile(String selectedFile) {
        this.reference2 = selectedFile;
        references2.put(selectedFile, this);
        Debug.event((Logger)logger, (String)ChartingFile.class.getName(), (String)"ChartingFile()", (Object)"Added Reference ", (Object)selectedFile);
    }

    public static boolean referenceExists(IFile selectedFile) {
        return ChartingFile.referenceExists(selectedFile.getFullPath().toString());
    }

    public static boolean referenceExists(String selectedFile) {
        return references2.containsKey(selectedFile);
    }

    @Override
    public String getReference() {
        return this.reference2;
    }

    @Override
    public String getAbridgedReference() {
        return this.getReference();
    }

    @Override
    public String getTabName() {
        this.tabName = this.tabName == null && Utilities.hasContent((String)this.reference2) ? new Path(this.reference2).lastSegment() : "";
        return this.tabName;
    }

    @Override
    public String getId() {
        return this.reference2;
    }

    @Override
    public synchronized Object[][] getData() {
        if (this.data == null) {
            this.getData(null);
        }
        return this.data;
    }

    public static GenericDataProvider getReference(String id) {
        GenericDataProvider provider = references2.get(id);
        if (provider == null && id != null) {
            provider = CSVFile.getReference(id);
        }
        return provider;
    }

    public static GenericDataProvider getReference(IFile id) {
        GenericDataProvider provider = references2.get(id.getFullPath().toPortableString());
        if (provider == null) {
            provider = CSVFile.getReference(id);
        }
        return provider;
    }

    public static void resetReference(String id) {
        references2.remove(id);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public String deriveSubReferenceFor(String append) {
        if (Utilities.hasContent((String)this.reference2)) {
            return String.valueOf(this.reference2) + append;
        }
        return append;
    }

    public boolean equals(Object object) {
        return object instanceof GenericDataProvider && ((GenericDataProvider)object).getReference().equals(this.getReference());
    }

    @Override
    public String getFileReference() {
        if (this.reference2 == null) {
            try {
                this.reference2 = "TODO";
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, ChartingFile.class.getName(), "getIFile", e.getMessage());
            }
        }
        return this.reference2;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isCorrupted() {
        return this.corrupted;
    }

    @Override
    public TreeElement getRootTreeElement() {
        if (this.explorerViewModel == null) {
            this.getExplorerViewModel();
        }
        return this.explorerViewModel;
    }

    public synchronized TreeElement getExplorerViewModel() {
        if (this.explorerViewModel == null) {
            Debug.enter((Logger)logger, (String)ChartingFile.class.getName(), (String)"getExplorerViewModel", (Object)this);
            Date start = new Date();
            DataProviderKey structureKey = this.getDataProviderKey();
            this.explorerViewModel = ExplorerViewModel.createExplorerViewModel(this, structureKey);
            if (structureKey.equals((Object)DataProviderKey.NONE)) {
                this.valid = false;
            } else {
                int[] relativeColumns = this.getColumnPositions(structureKey);
                TreeElement[] parents = new TreeElement[relativeColumns.length];
                parents[0] = this.explorerViewModel;
                Object[][] data = this.getData();
                if (Display.getCurrent() != null && this instanceof CSVFile) {
                    logger.logp(Level.WARNING, ChartingFile.class.getName(), "getExplorerViewModel", "Incorrect thread access in " + this.toString());
                }
                if (data != null && this.isValid()) {
                    int i = 0;
                    while (i < data.length) {
                        TreeElement aChild = this.explorerViewModel;
                        int j = 0;
                        while (j < parents.length) {
                            if (data[i][relativeColumns[j]] != null) {
                                try {
                                    if (j == parents.length - 1) {
                                        aChild = aChild.getChild(structureKey.getColumnDefinitions()[j], data[i][relativeColumns[j]], relativeColumns[j], data[i]);
                                        this.allresults.add((IUniqueRecord)aChild);
                                    } else {
                                        aChild = aChild.getChild(structureKey.getColumnDefinitions()[j], data[i][relativeColumns[j]], relativeColumns[j]);
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    logger.logp(Level.SEVERE, CSVFile.class.getName(), "getExplorerViewModel", "Array Index error", ex);
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                Debug.event((Logger)logger, (String)ChartingFile.class.getName(), (String)(String.valueOf(this.getReference()) + " milliseconds = " + (new Date().getTime() - start.getTime())));
            }
            Debug.exit((Logger)logger, (String)ChartingFile.class.getName(), (String)"getExplorerViewModel");
        }
        return this.explorerViewModel;
    }

    @Override
    public void resetOrdering() {
        if (this.isPopulated() && !this.isDisposed) {
            Job job = new Job(Messages.getString("SheetProxy.Initializing")){

                protected IStatus run(IProgressMonitor monitor) {
                    int i = ChartingFile.this.getDataProviderKey().getColumnDefinitions().length - 1;
                    while (i >= 0) {
                        final ColumnDefinition sortColumn = ChartingFile.this.getDataProviderKey().getColumnDefinitions()[i];
                        if (ChartingFile.this.data != null) {
                            Arrays.sort(ChartingFile.this.data, new Comparator<Object[]>(){

                                @Override
                                public int compare(Object[] a, Object[] b) {
                                    return DataTypeUtilities.compare(sortColumn, 128, a[ChartingFile.this.getColumnPosition(sortColumn)], b[ChartingFile.this.getColumnPosition(sortColumn)]);
                                }
                            });
                        }
                        --i;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.schedule();
        }
    }

    public void dispose() {
        if (!this.isDisposed) {
            Debug.event((Logger)logger, (String)ChartingFile.class.getName(), (String)"dispose", (Object)("Removed file reference " + this.getReference()));
            ChartingFile.resetReference(this.getFileReference());
            this.isDisposed = true;
            this.data = null;
            if (this.explorerViewModel != null) {
                this.explorerViewModel.clear();
                this.explorerViewModel = null;
            }
            if (this.resourceListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            }
        }
    }

    @Override
    public void incrementUseCount() {
        Debug.enter((Logger)logger, (String)ChartingFile.class.getName(), (String)"incrementUseCount", (Object)this.getReference());
        ++this.useCount;
        Debug.exit((Logger)logger, (String)ChartingFile.class.getName(), (String)"incrementUseCount", (Object)(String.valueOf(this.getReference()) + " " + this.useCount));
    }

    @Override
    public void decrementUseCount() {
        Debug.enter((Logger)logger, (String)ChartingFile.class.getName(), (String)"decrementUseCount", (Object)this.getReference());
        --this.useCount;
        if (this.useCount <= 0) {
            this.dispose();
        }
        Debug.exit((Logger)logger, (String)ChartingFile.class.getName(), (String)"decrementUseCount", (Object)(String.valueOf(this.getReference()) + " " + this.useCount));
    }

    @Override
    public List<ChartSelectable> getSelectableColumns(ChartSpecification chartReference, IProgressMonitor monitor) {
        ArrayList<ChartSelectable> primaryColumns = new ArrayList<ChartSelectable>();
        int i = 0;
        while (i < this.getData().length) {
            IUniqueRecord inst = this.getRootTreeElement().findExplorerViewModelElement(this.getData()[i]);
            SelectableColumn column = null;
            switch (chartReference.getSpecificType().getChartType()) {
                case HISTOGRAM: 
                case BARCHARTVIEW: 
                case COMBINEDHISTOGRAMLINE: 
                case COMPACT_HISTOGRAM: {
                    column = new SelectableColumn(inst, chartReference, this.getColumnDefinitions());
                    break;
                }
            }
            primaryColumns.add(column);
            if (monitor != null && monitor.isCanceled()) break;
            ++i;
        }
        return primaryColumns;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public IUniqueRecord locateUniqueRecordForRow(Object[] object) {
        return this.getRootTreeElement().findExplorerViewModelElement(object);
    }

    public static GenericDataProvider adaptFor(GenericDataProvider genericDataProvider, StructuredSelection elements, ChartSpecification defn) {
        if (genericDataProvider instanceof RemoteConnectionProvider || genericDataProvider instanceof HierarchicalRemoteElement || genericDataProvider instanceof RemoteEditorInput) {
            return RemoteEditorInput.createAlreadyPopulated(genericDataProvider, elements, defn);
        }
        CSVDataRestrictionFilter filter = CSVDataRestrictionFilter.getFilterFor(elements);
        return CSVDataExtract.getFor(genericDataProvider, filter);
    }

    public static GenericDataProvider adaptForSpecific(GenericDataProvider genericDataProvider, IUniqueRecord record, ChartSpecification defn) {
        if (genericDataProvider instanceof RemoteConnectionProvider || genericDataProvider instanceof HierarchicalRemoteElement || genericDataProvider instanceof RemoteEditorInput) {
            return RemoteEditorInput.createAlreadyPopulated(genericDataProvider, new StructuredSelection((Object)record), defn);
        }
        SpecificRowsFilter filter = SpecificRowsFilter.specificFilterFor(genericDataProvider, new IUniqueRecord[]{record});
        return CSVDataExtract.getFor(genericDataProvider, filter);
    }

    public boolean exists() {
        return this.isPopulated() && !this.isDisposed;
    }

    @Override
    public boolean passwordCheck() {
        return false;
    }

    @Override
    public Collection<IUniqueRecord> getAllResults() {
        return this.allresults;
    }

    @Override
    public GenericDataProvider sort(DBQueryFactoryCustomer recipientView, final ColumnDefinition defn, final int direction, final int realIndex, List<FilterElement> filters) {
        if (filters == null || filters.isEmpty()) {
            if (direction == 0) {
                this.resetOrdering();
            } else {
                Arrays.sort(this.getData(), new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] a, Object[] b) {
                        return DataTypeUtilities.compare(defn, direction, a[realIndex], b[realIndex]);
                    }
                });
            }
        } else {
            GenericDataProvider derived = CSVDataExtract.getFor((GenericDataProvider)this, SQLStyleCSVFilter.getFilterFor(this, filters));
            if (direction == 0) {
                this.getRootSource().resetOrdering();
            } else {
                Arrays.sort(derived.getData(), new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] a, Object[] b) {
                        return DataTypeUtilities.compare(defn, direction, a[realIndex], b[realIndex]);
                    }
                });
            }
            return derived;
        }
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

