/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import java.util.EnumSet;

public enum ChartType {
    PIE("com.ibm.cics.pa.ui.pie_editor"),
    SHEET("com.ibm.cics.pa.ui.sheeteditor_multi"),
    HISTOGRAM("com.ibm.cics.pa.ui.charteditor"),
    BARCHARTVIEW("com.ibm.cics.pa.ui.charteditor"),
    LINE("com.ibm.cics.pa.ui.charteditor"),
    COMBINEDHISTOGRAMLINE("com.ibm.cics.pa.ui.charteditor"),
    COMPACT_HISTOGRAM("com.ibm.cics.pa.ui.charteditor"),
    INTERVAL_PLOT("com.ibm.cics.pa.ui.plotview"),
    PERFORMANCE_RECORD("com.ibm.cics.pa.ui.performance_record"),
    YARDSTICK("com.ibm.cics.pa.yard");

    private String id;

    private ChartType(String id) {
        this.id = id;
    }

    public static ChartType getById(String id) {
        for (ChartType type : EnumSet.allOf(ChartType.class)) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public static ChartType deriveFrom(String implType) {
        if (implType.equals("Histogram")) {
            return HISTOGRAM;
        }
        if (implType.equals("Timeline")) {
            return COMPACT_HISTOGRAM;
        }
        if (implType.equals("Combined")) {
            return COMBINEDHISTOGRAMLINE;
        }
        if (implType.equals("Pie")) {
            return PIE;
        }
        if (implType.equals("Link")) {
            return SHEET;
        }
        if (implType.equals("Interval")) {
            return INTERVAL_PLOT;
        }
        return SHEET;
    }
}

