/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.CSVDataProviderFilter;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.TreeElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.jface.viewers.StructuredSelection;

public class CSVDataRestrictionFilter
implements CSVDataProviderFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static HashMap<DataKeyElement[], CSVDataRestrictionFilter> loadedFilters = new HashMap();
    private String reference = null;
    private String[] derivedKeys;
    private DataKeyElement[] keys = null;
    private GenericDataProvider provider;

    public static CSVDataRestrictionFilter getFilterFor(StructuredSelection explorerModel) {
        GenericDataProvider provider1 = ((TreeElement)explorerModel.getFirstElement()).getSourceProvider();
        Iterator iterator = explorerModel.iterator();
        ArrayList<DataKeyElement> tempKeys = new ArrayList<DataKeyElement>();
        while (iterator.hasNext()) {
            Object selected = iterator.next();
            if (!(selected instanceof TreeElement)) continue;
            TreeElement modelSelection = (TreeElement)selected;
            DataKeyElement element = modelSelection.getDataKey();
            tempKeys.add(element);
        }
        return CSVDataRestrictionFilter.getFilterFor(provider1, tempKeys.toArray(new DataKeyElement[tempKeys.size()]));
    }

    @Override
    public boolean accepts(Object[] dataRow) {
        boolean match = false;
        int i = 0;
        while (i < this.keys.length) {
            match = true;
            LinkedHashMap<Integer, Object> mapping = this.keys[i].getReferenceMapFor(this.provider);
            for (Integer mappedKey : mapping.keySet()) {
                boolean bl = match = match ? dataRow[mappedKey].equals(mapping.get(mappedKey)) : false;
            }
            if (match) {
                return match;
            }
            ++i;
        }
        return match;
    }

    public boolean equals(Object filter) {
        if (filter instanceof CSVDataRestrictionFilter) {
            return this.getReference().equals(((CSVDataRestrictionFilter)filter).getReference());
        }
        return false;
    }

    @Override
    public String getReference() {
        if (this.reference == null) {
            this.reference = "";
            String[] stringArray = this.derivedKeys;
            int n = this.derivedKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.reference = String.valueOf(this.reference) + key + "+";
                ++n2;
            }
        }
        return this.reference;
    }

    @Override
    public String getId() {
        return String.valueOf(this.getReference().hashCode());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static CSVDataRestrictionFilter getFilterFor(GenericDataProvider provider, DataKeyElement[] dataKeyElements) {
        CSVDataRestrictionFilter filter = null;
        String[] derivedKeys = new String[dataKeyElements.length];
        int i = 0;
        while (i < dataKeyElements.length) {
            derivedKeys[i] = dataKeyElements[i].getFullDescriptiveReference();
            ++i;
        }
        filter = loadedFilters.get(derivedKeys);
        if (filter == null) {
            filter = new CSVDataRestrictionFilter(provider, dataKeyElements, derivedKeys);
        }
        return filter;
    }

    private CSVDataRestrictionFilter(GenericDataProvider provider, DataKeyElement[] dataKeyElements, String[] derivedKeys) {
        this.keys = dataKeyElements;
        loadedFilters.put(dataKeyElements, this);
        this.provider = provider;
        this.derivedKeys = derivedKeys;
    }
}

