/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.CSVFile;
import com.ibm.cics.pa.model.ExplorerViewModel;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.swt.widgets.Display;

public class CSVDataAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static final Class[] ADAPTER_TYPES = new Class[]{TreeElement.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        Debug.enter((Logger)logger, (String)CSVDataAdapterFactory.class.getName(), (String)"getAdapter", (Object)this);
        TreeElement theDaddy = null;
        if (TreeElement.class.equals((Object)adapterType) && adaptableObject instanceof GenericDataProvider) {
            DataProviderKey structureKey = ((GenericDataProvider)adaptableObject).getDataProviderKey();
            Date start = new Date();
            theDaddy = ExplorerViewModel.createExplorerViewModel((GenericDataProvider)adaptableObject, structureKey);
            int[] relativeColumns = ((GenericDataProvider)adaptableObject).getColumnPositions(structureKey);
            TreeElement[] parents = new TreeElement[Math.max(relativeColumns.length, 1)];
            parents[0] = theDaddy;
            Object[][] data = ((GenericDataProvider)adaptableObject).getData();
            if (Display.getCurrent() != null && adaptableObject instanceof CSVFile) {
                logger.logp(Level.WARNING, CSVDataAdapterFactory.class.getName(), "getAdapter", "Incorrect thread access in " + this.toString());
            }
            if (data != null && ((GenericDataProvider)adaptableObject).isValid()) {
                int i = 0;
                while (i < data.length) {
                    TreeElement aChild = theDaddy;
                    int j = 0;
                    while (j < parents.length) {
                        if (data[i][relativeColumns[j]] != null) {
                            try {
                                aChild = j == parents.length - 1 ? aChild.getChild(structureKey.getColumnDefinitions()[j], data[i][relativeColumns[j]], relativeColumns[j], data[i]) : aChild.getChild(structureKey.getColumnDefinitions()[j], data[i][relativeColumns[j]], relativeColumns[j]);
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                logger.logp(Level.SEVERE, CSVFile.class.getName(), "getAdapter", "Array Index error", ex);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            Debug.event((Logger)logger, (String)CSVDataAdapterFactory.class.getName(), (String)(String.valueOf(((GenericDataProvider)adaptableObject).getReference()) + " milliseconds = " + (new Date().getTime() - start.getTime())));
        }
        Debug.exit((Logger)logger, (String)CSVDataAdapterFactory.class.getName(), (String)"getAdapter", theDaddy);
        return theDaddy;
    }

    public Class[] getAdapterList() {
        return ADAPTER_TYPES;
    }
}

