/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.comm;

import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.IntervalsCaveat;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.SimpleTreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.sm.comm.IContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class PASelectionContext
implements IContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DateCaveat dates;
    private List<String> applids = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private ColumnDefinition resourceColumn;
    private SimpleTreeElement element;
    private List<String> applications = new ArrayList<String>();
    private List<String> operations = new ArrayList<String>();
    private List<String> platforms = new ArrayList<String>();
    private List<String> versions = new ArrayList<String>();

    public PASelectionContext(DateCaveat dates, List<String> applids, List<String> resources, ColumnDefinition resourceColumn) {
        this.dates = dates;
        this.applids = applids;
        this.resources = resources;
        this.resourceColumn = resourceColumn;
    }

    public PASelectionContext(DateCaveat dates, List<String> platforms, List<String> applications, List<String> versions, List<String> operations) {
        this.dates = dates;
        this.platforms = platforms;
        this.applications = applications;
        this.operations = operations;
        this.versions = versions;
    }

    public static PASelectionContext getPASelectionContext(ISelection selection) {
        PASelectionContext ctx = null;
        if (((StructuredSelection)selection).getFirstElement() instanceof SimpleTreeElement) {
            ctx = new PASelectionContext(selection);
        }
        return ctx;
    }

    private PASelectionContext(ISelection selection) {
        this.dates = null;
        this.element = (SimpleTreeElement)((StructuredSelection)selection).getFirstElement();
    }

    public String getLabelWithoutDates() {
        String context = "";
        if (this.element != null) {
            context = String.valueOf(context) + this.element.getContentDescriptionLabel();
        } else {
            int i = 0;
            while (i < this.applids.size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.applids.get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.resources.size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.resources.get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getPlatforms().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getPlatforms().get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getApplications().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getApplications().get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getVersions().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getVersions().get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getOperations().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getOperations().get(i).toString();
                ++i;
            }
        }
        return context;
    }

    public String getContext() {
        String context = "";
        if (this.element != null) {
            context = String.valueOf(context) + this.element.getContentDescriptionLabel();
        } else {
            if (this.dates != null) {
                context = String.valueOf(context) + this.dates.getLabel();
            }
            int i = 0;
            while (i < this.applids.size()) {
                context = String.valueOf(context) + (i == 0 ? " " : ", ");
                context = String.valueOf(context) + this.applids.get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.resources.size()) {
                context = String.valueOf(context) + (i == 0 ? " " : ", ");
                context = String.valueOf(context) + this.resources.get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getPlatforms().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getPlatforms().get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getApplications().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getApplications().get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getVersions().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getVersions().get(i).toString();
                ++i;
            }
            i = 0;
            while (i < this.getOperations().size()) {
                context = String.valueOf(context) + (i == 0 ? "" : ", ");
                context = String.valueOf(context) + this.getOperations().get(i).toString();
                ++i;
            }
        }
        return context;
    }

    public String getContentDescriptionLabel() {
        return this.toString();
    }

    public int hashCode() {
        return this.getContext().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PASelectionContext && this.hashCode() == ((PASelectionContext)obj).hashCode();
    }

    public List<String> getResources() {
        return this.resources;
    }

    public List<String> getApplids() {
        return this.applids;
    }

    public SimpleTreeElement getElement() {
        return this.element;
    }

    public DateCaveat getDates() {
        return this.dates;
    }

    public Selection getSummarySelection(String table) {
        Selection selection = PresentationFactory.getInstance().createSelectAllForTable(table, ":schema");
        if (this.element != null) {
            this.element.applyConstraint(selection);
        }
        if (!this.getPlatforms().isEmpty()) {
            selection.appendCondition(ColumnDefinition.ACPLATNM.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.IN, this.getPlatforms().toArray(), QueryElement.Predicate.AND, false);
        }
        if (!this.getVersions().isEmpty()) {
            selection.appendCondition(ColumnDefinition.ACAPPLVR.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.IN, this.getVersions().toArray(), QueryElement.Predicate.AND, false);
        }
        if (!this.getApplications().isEmpty()) {
            selection.appendCondition(ColumnDefinition.ACAPPLNM.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.IN, this.getApplications().toArray(), QueryElement.Predicate.AND, false);
        }
        if (!this.getOperations().isEmpty()) {
            selection.appendCondition(ColumnDefinition.ACOPERNM.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.IN, this.getOperations().toArray(), QueryElement.Predicate.AND, false);
        }
        if (!this.getApplids().isEmpty()) {
            selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.IN, this.getApplids().toArray(), QueryElement.Predicate.AND, false);
        }
        if (!this.getResources().isEmpty()) {
            selection.appendCondition(this.resourceColumn.getDBColumnRef(), table, this.resourceColumn.getType(), Comparator.IN, this.getResources().toArray(), QueryElement.Predicate.AND, false);
        }
        if (this.dates != null && !(this.dates instanceof NullRangeDateCaveat)) {
            selection.appendCondition(this.dates.getConstraint(null, ManifestRecord.isPerformanceList(table)), QueryElement.Predicate.AND);
        }
        if (!(ManifestRecord.isPerformanceSummaryRecord(table) || ManifestRecord.isApplicationSummaryRecord(table) || ManifestRecord.isPerformanceList(table) || IntervalsCaveat.getInstance().getClause() == null)) {
            selection.appendCondition((ConstraintElement)IntervalsCaveat.getInstance().getClause(), QueryElement.Predicate.AND);
        }
        return selection;
    }

    public String toString() {
        if (this.element != null) {
            return this.element.getContentDescriptionLabel();
        }
        String context = "";
        String applidString = "";
        int i = 0;
        while (i < this.getApplids().size()) {
            applidString = String.valueOf(applidString) + (i == 0 ? "" : ", ");
            applidString = String.valueOf(applidString) + this.getApplids().get(i).toString();
            ++i;
        }
        String resourceString = "";
        int i2 = 0;
        while (i2 < this.getResources().size()) {
            resourceString = String.valueOf(resourceString) + (i2 == 0 ? "" : ", ");
            resourceString = String.valueOf(resourceString) + this.getResources().get(i2).toString();
            ++i2;
        }
        if (applidString.length() > 0) {
            context = resourceString.length() > 0 ? MessageFormat.format(Messages.getString("ContentDescription.Applid.Resource"), applidString, resourceString) : MessageFormat.format(Messages.getString("ContentDescription.Applid"), applidString);
        }
        String platformString = "";
        int i3 = 0;
        while (i3 < this.getPlatforms().size()) {
            platformString = String.valueOf(platformString) + (i3 == 0 ? "" : ", ");
            platformString = String.valueOf(platformString) + this.getPlatforms().get(i3).toString();
            ++i3;
        }
        String applicationString = "";
        int i4 = 0;
        while (i4 < this.getApplications().size()) {
            applicationString = String.valueOf(applicationString) + (i4 == 0 ? "" : ", ");
            applicationString = String.valueOf(applicationString) + this.getApplications().get(i4).toString();
            ++i4;
        }
        String versionString = "";
        int i5 = 0;
        while (i5 < this.getVersions().size()) {
            versionString = String.valueOf(versionString) + (i5 == 0 ? "" : ", ");
            versionString = String.valueOf(versionString) + this.getVersions().get(i5).toString().trim();
            ++i5;
        }
        String operationString = "";
        int i6 = 0;
        while (i6 < this.getOperations().size()) {
            operationString = String.valueOf(operationString) + (i6 == 0 ? "" : ", ");
            operationString = String.valueOf(operationString) + this.getOperations().get(i6).toString();
            ++i6;
        }
        if (platformString.length() > 0) {
            context = applicationString.length() > 0 ? (versionString.length() > 0 ? (operationString.length() > 0 ? MessageFormat.format(Messages.getString("ContentDescription.Platform.Application.Version.Operation"), platformString, applicationString, versionString, operationString) : MessageFormat.format(Messages.getString("ContentDescription.Platform.Application.Version"), platformString, applicationString, versionString)) : MessageFormat.format(Messages.getString("ContentDescription.Platform.Application"), platformString, applicationString)) : MessageFormat.format(Messages.getString("ContentDescription.Platform"), platformString);
        }
        if (this.dates != null) {
            context = String.valueOf(context) + " " + this.dates.getLabel();
        }
        return context;
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public List<String> getApplications() {
        return this.applications;
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public boolean isPopulated() {
        return !this.applids.isEmpty() || !this.applications.isEmpty() || this.element != null;
    }

    public boolean isRelevant(ManifestRecord record) {
        return record.isApplicationSummaryRecord() ? !this.applications.isEmpty() : !this.applids.isEmpty() || this.element != null;
    }
}

