<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html"/>
  <xsl:template match="/">
    <xsl:apply-templates select="threadsafe-report"/>
  </xsl:template>
  <xsl:template match="threadsafe-report">
<!-- NLS_CHARSET=UTF-8 -->
    <html>
      <head>
	<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8"/>
        <title>Threadsafe Report</title>
        <style type="text/css">
	h1
	{
		font-size:20px;
	}
	h2
	{
		font-size:16px;
	}
	p
	{
		font-size:12px;
	}
	table.common
	{
		border-collapse:collapse;
		border:1px solid black;
	}
	table.embedded
	{
		border-collapse:collapse;
		border:1px;		
		width:100%
	}
	th
	{
		background-color:gray;
		border:1px solid black;
		padding:2px;
		font-size:"12";
	}
	th.embedded
	{
		background-color:lightgray;
		border:1px solid black;
		padding:2px;
		font-size:"12";
	}
	td.common
	{
		white-space:nowrap;
		border:1px solid black;
		padding:5px;
		font-size:"12";
	}
	td.nopadding
	{
		border:0px;
		padding:0px;
		font-size:"12";
	}
</style>
      </head>
      <body>
        <h1>CICS INTERDEPENDENCY ANALYZER VERSION <xsl:value-of select="@ia-version"/></h1>
        <p>
          <xsl:value-of select="@date"/>
        </p>
        <h2>Program Dynamic Analysis - THREADSAFE

       <xsl:choose><xsl:when test="//summary/details">
			DETAIL
         </xsl:when><xsl:otherwise>
			SUMMARY
         </xsl:otherwise></xsl:choose>

LISTING FOR CICS TS</h2>
        <p>
          <h2>Definitions of Terms:</h2>
          <ul>
            <li><b>'Threadsafe'</b> calls are EXEC CALLS commands that do not cause a TCB swap.</li>
            <li><b>'Non-Threadsafe'</b> calls are EXEC CALLS commands that cause a TCB swap.</li>
            <li><b>'Indeterminate Threadsafe'</b> calls are EXEC CALLS commands where it cannot be determined if the call causes a TCB swap.</li>
            <li><b>'Dynamic calls'</b> are calls to modules at execution time. Programs that are called dynamically take on the same environment as the calling program.</li>
            <li><b>'Threadsafe Inhibitor calls'</b> are EXEC CICS commands that need to be investigated further because they may prevent you from defining your program as threadsafe. 
			These commands are: <b>ADDRESS CWA</b>, <b>EXTRACT EXIT</b>, <b>GETMAIN SHARED</b>, and <b>LOAD</b>.</li>
          </ul>
        </p>
        <xsl:apply-templates select="options">
          <xsl:with-param name="details">
            <xsl:choose>
              <xsl:when test="//summary/details">
Yes
         </xsl:when>
              <xsl:otherwise>
No
         </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:apply-templates>
        <table class="common" bgcolor="#DDDDDD">
          <th>CICS IA collected resources collection ID</th>
          <th>CICS TS region APPLID</th>
          <th>Program name</th>
          <th>Program's library dataset name</th>
          <th>Program's installed definition API attribute value</th>
          <th>Program's installed definition CONCURRENCY attribute value</th>
          <th>Program's storage code</th>
          <th>Program is linked as reentrant</th>
          <th>CICS release summary threadsafe report data is prepared for (640, 650, etc)</th>
          <th>CICS release summary threadsafe report data is prepared for (3.2, 4.1, etc)</th>
          <th>CICS storage protect mode</th>
          <xsl:variable name="colNum">11</xsl:variable>
          <xsl:for-each select="summary">
            <tr>
              <td class="common">
                <xsl:value-of select="collection-id"/>
              </td>
              <td class="common">
                <xsl:value-of select="applid"/>
              </td>
              <td class="common">
                <xsl:value-of select="program"/>
              </td>
              <td class="common">
                <xsl:value-of select="lib-dataset"/>
              </td>
              <td class="common">
                <xsl:value-of select="apist"/>
              </td>
              <td class="common">
                <xsl:value-of select="concurrency"/>
              </td>
              <td class="common">
                <xsl:value-of select="execution-key"/>
              </td>
              <td class="common">
                <xsl:value-of select="reentrant"/>
              </td>
              <td class="common">
                <xsl:value-of select="cics-release-internal"/>
              </td>
              <td class="common">
                <xsl:value-of select="cics-release-external"/>
              </td>
              <td class="common">
                <xsl:value-of select="storage-protect"/>
              </td>
            </tr>
            <xsl:if test="details">
              <tr>
                <td colspan="{$colNum}">
                  <table class="common" bgcolor="#FFFFFF">
                    <th class="embedded">EXEC CICS command name</th>
                    <th class="embedded">Resource type</th>
                    <th class="embedded">Resource name</th>
                    <th class="embedded">The offset of the command from the start of the program</th>
                    <th class="embedded">Total number of the command occurrences</th>
                    <th class="embedded">Command threadsafe status</th>
                    <th class="embedded">Inhibitor call flag</th>
                    <xsl:for-each select="details/detail">
                      <tr>
                        <td class="common">
                          <xsl:value-of select="function"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="type"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="object"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="offset"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="use-count"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="threadsafe"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="inhibitor"/>
                        </td>
                      </tr>
                    </xsl:for-each>
                  </table>
                </td>
              </tr>
            </xsl:if>
            <tr>
              <td colspan="{$colNum}">
                <table class="embedded" bgcolor="#FFFFFF">
                  <tr>
                    <td class="common" width="16%">Total number of CICS calls:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="cics-calls/total-cics-calls"/>
                    </td>
                    <td class="common" width="16%">Threadsafe:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="cics-calls/threadsafe"/>
                    </td>
                    <td class="common" width="16%">Non-threadsafe:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="cics-calls/non-threadsafe"/>
                    </td>
                  </tr>
                  <tr>
                    <td class="common" width="16%">Indeterminate Threadsafe:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="db2-mq-calls/indeterminate-threadsafe"/>
                    </td>
                    <td class="common" width="16%">Total number of DB2 calls:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="db2-mq-calls/total-db2-calls"/>
                    </td>
                    <td class="common" width="16%">Total number of MQ calls:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="db2-mq-calls/total-mq-calls"/>
                    </td>
                  </tr>
                  <tr>
                    <td class="common" width="16%">Total number of IMS calls:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="ims-calls/total-ims-calls"/>
                    </td>
                    <td class="common" width="16%">Total number of dynamic calls:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="ims-calls/dynamic-calls"/>
                    </td>
                    <td class="common" width="16%">Total number of threadsafe inhibitor calls:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="ims-calls/threadsafe-inhibitor-calls"/>
                    </td>
                  </tr>
                  <!-- Only available in 5.2 and later versions -->
                  <xsl:if test="cpsm-calls">
                    <tr>
                      <td class="common" width="16%">Total number of CPSM calls:</td>
                      <td class="common" width="16%">
                        <xsl:value-of select="cpsm-calls/total-cpsm-calls"/>
                      </td>
                      <td class="common" width="16%">Threadsafe:</td>
                      <td class="common" width="16%">
                        <xsl:value-of select="cpsm-calls/threadsafe"/>
                      </td>
                      <td class="common" width="16%">Non-threadsafe:</td>
                      <td class="common" width="16%">
                        <xsl:value-of select="cpsm-calls/non-threadsafe"/>
                      </td>
                    </tr>
                  </xsl:if>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="{$colNum}">
                <br/>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="options">
    <xsl:param name="details"/>
    <table class="common">
      <th colspan="2">Report options</th>
      <tr>
        <td bgcolor="#DDDDDD" class="common">Collection ID</td>
        <td class="common">
          <xsl:value-of select="collection-id"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">Region</td>
        <td class="common">
          <xsl:value-of select="region"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">
          <xsl:if test="resource/@type = 'PROGRAM'">
Program name
					</xsl:if>
          <xsl:if test="resource/@type = 'TRANSID'">
Transaction name
					</xsl:if>
        </td>
        <td class="common">
          <xsl:value-of select="resource"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">CICS TS level</td>
        <td class="common">
          <xsl:value-of select="cics-ts-level"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">Details</td>
        <td class="common">
          <xsl:value-of select="$details"/>
        </td>
      </tr>
    </table>
    <br/>
  </xsl:template>
</xsl:stylesheet>
