<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="text"/>
  <xsl:param name="type"/>
  <xsl:variable name="newline">
    <xsl:text>
</xsl:text>
  </xsl:variable>
  <xsl:template match="/">
    <xsl:apply-templates select="threadsafe-report"/>
  </xsl:template>
  <xsl:template match="threadsafe-report">
    <xsl:choose>
      <xsl:when test="$type = 'summaries'">
Collection ID,APPLID,Program,LIB Dataset Name,APIST,Concurrency,Execution Key,Storage Protect,Reentrant, CICS Release,Total CICS Calls,Threadsafe,Non-Threadsafe,Indeterminate Threadsafe,Total DB2 Calls,Total MQ Calls,Total IMS Calls,Total Dynamic Calls,Total Threadsafe Inhibitor Calls<xsl:if test="summary/cpsm-calls">,Total CPSM Calls,Threadsafe,Non-Threadsafe</xsl:if>
<xsl:value-of select="$newline"/>
<xsl:for-each select="summary"><xsl:value-of select="collection-id"/>,<xsl:value-of select="applid"/>,<xsl:value-of select="program"/>,<xsl:value-of select="lib-dataset"/>,<xsl:value-of select="apist"/>,<xsl:value-of select="concurrency"/>,<xsl:value-of select="execution-key"/>,<xsl:value-of select="storage-protect"/>,<xsl:value-of select="reentrant"/>,<xsl:value-of select="cics-release-internal"/>,<xsl:value-of select="cics-calls/total-cics-calls"/>,<xsl:value-of select="cics-calls/threadsafe"/>,<xsl:value-of select="cics-calls/non-threadsafe"/>,<xsl:value-of select="db2-mq-calls/indeterminate-threadsafe"/>,<xsl:value-of select="db2-mq-calls/total-db2-calls"/>,<xsl:value-of select="db2-mq-calls/total-mq-calls"/>,<xsl:value-of select="ims-calls/total-ims-calls"/>,<xsl:value-of select="ims-calls/dynamic-calls"/>,<xsl:value-of select="ims-calls/threadsafe-inhibitor-calls"/><!-- CPSM is only available in 5.2 and later versions --><xsl:choose><xsl:when test="cpsm-calls">,<xsl:value-of select="cpsm-calls/total-cpsm-calls"/>,<xsl:value-of select="cpsm-calls/threadsafe"/>,<xsl:value-of select="cpsm-calls/non-threadsafe"/>
</xsl:when><xsl:otherwise/></xsl:choose><xsl:value-of select="$newline"/></xsl:for-each>
</xsl:when>
      <xsl:otherwise>
Collection ID,APPLID,Program,Command Type,Function,Type,Object,Offset,Use count,Threadsafe,Inhibitor
<xsl:for-each select="summary/details/detail"><xsl:value-of select="../../collection-id"/>,<xsl:value-of select="../../applid"/>,<xsl:value-of select="../../program"/>,<xsl:value-of select="command-type"/>,<xsl:value-of select="function"/>,<xsl:value-of select="type"/>,<xsl:call-template name="prepareForCsv"><xsl:with-param name="text" select="object"/></xsl:call-template>,<xsl:value-of select="offset"/>,<xsl:value-of select="use-count"/>,<xsl:value-of select="threadsafe"/>,<xsl:value-of select="inhibitor"/><xsl:value-of select="$newline"/></xsl:for-each>
</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="prepareForCsv">
    <xsl:param name="text"/>
    <xsl:choose>
      <xsl:when test="contains($text, ',')">
        <xsl:text>&quot;</xsl:text>
        <xsl:call-template name="escapeQuotes">
          <xsl:with-param name="text" select="$text"/>
        </xsl:call-template>
        <xsl:text>&quot;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="escapeQuotes">
    <xsl:param name="text"/>
    <xsl:if test="string-length($text) &gt;0">
      <xsl:value-of select="substring-before(concat($text, '&quot;'), '&quot;')"/>
      <xsl:if test="contains($text, '&quot;')">
        <xsl:text>""</xsl:text>
        <xsl:call-template name="escapeQuotes">
          <xsl:with-param name="text" select="substring-after($text, '&quot;')"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
