/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.wsaa;

import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.runtime.IAPlugin;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class LaunchProgramDetailsObjectActionDelegate
implements IObjectActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Program program;
    private String programName;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Preferences prefs = IAPlugin.getDefault().getPluginPreferences();
        if (this.programName != null) {
            String externalURL = MessageFormat.format("http://{0}:{1}/dmh/UrlApi?View=Summary&AssetType=Program&s_Name={2}&RedirectSingle=Y", prefs.getString("WSAA_SERVER_NAME"), Integer.toString(prefs.getInt("WSAA_PORT_NUMBER")), this.programName);
            try {
                String encodedNoSpacesURL = Utilities.urlEncodeSpaces((String)externalURL);
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser browser = support.getExternalBrowser();
                browser.openURL(new URL(encodedNoSpacesURL));
            }
            catch (Exception e) {
                IAPlugin.getDefault().logError("Unable to open RAA program details view for URL " + externalURL, (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object firstElement;
        this.program = null;
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Program) {
            this.setProgram((Program)firstElement);
        }
    }

    protected void setProgram(Program aProgram) {
        this.program = aProgram;
        this.programName = aProgram != null ? aProgram.getName() : null;
    }

    public void setProgramName(String aProgramName) {
        this.programName = aProgramName;
    }

    protected Program getProgram() {
        return this.program;
    }
}

