/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.layoutmanagers;

import com.ibm.cics.ia.ui.viz.editparts.SortedGraphEditPart;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class SortedGraphNode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int DEFAULT_MARGIN_LEFT = 30;
    public static final int DEFAULT_MARGIN_TOP = 60;
    public static final int DEFAULT_MARGIN_RIGHT = 30;
    public static final int DEFAULT_MARGIN_BOTTOM = 30;
    public static final int DEFAULT_HORIZONTAL_SPACING = 15;
    public static final int DEFAULT_VERTICAL_SPACING = 15;
    private ArrayList<SortedGraphNode> siblings;
    private ArrayList<SortedGraphNode> children = new ArrayList();
    private SortedGraphNode parent;
    private int level;
    private int index;
    private SortedGraphEditPart editPart;
    private int direction;
    private Point location;
    private Point bottomRight;
    private Rectangle outerBounds;
    private Point anchorTop;
    private Point anchorRight;
    private Point anchorBottom;
    private Point anchorLeft;

    public Point getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(Point bottomRight) {
        this.bottomRight = bottomRight;
    }

    public Point getAnchorTop() {
        return this.anchorTop;
    }

    public void setAnchorTop(Point anchorTop) {
        this.anchorTop = anchorTop;
    }

    public Point getAnchorRight() {
        return this.anchorRight;
    }

    public void setAnchorRight(Point anchorRight) {
        this.anchorRight = anchorRight;
    }

    public Point getAnchorBottom() {
        return this.anchorBottom;
    }

    public void setAnchorBottom(Point anchorBottom) {
        this.anchorBottom = anchorBottom;
    }

    public Point getAnchorLeft() {
        return this.anchorLeft;
    }

    public void setAnchorLeft(Point anchorLeft) {
        this.anchorLeft = anchorLeft;
    }

    public Rectangle getOuterBounds() {
        return this.outerBounds;
    }

    public void setOuterBounds(Rectangle outerBounds) {
        this.outerBounds = outerBounds;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
        this.bottomRight = location.getCopy();
    }

    public Dimension getSize() {
        return new Dimension(this.bottomRight.x - this.location.x, this.bottomRight.y - this.location.y);
    }

    public void setSize(Dimension size) {
        this.bottomRight.x = this.location.x + size.width();
        this.bottomRight.y = this.location.y + size.height();
    }

    public ArrayList<SortedGraphNode> getSiblings() {
        return this.siblings;
    }

    public void setSiblings(ArrayList<SortedGraphNode> siblings) {
        this.siblings = siblings;
    }

    public ArrayList<SortedGraphNode> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<SortedGraphNode> children) {
        this.children = children;
    }

    public SortedGraphNode getParent() {
        return this.parent;
    }

    public void setParent(SortedGraphNode parent) {
        this.parent = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public SortedGraphEditPart getEditPart() {
        return this.editPart;
    }

    public void setEditPart(SortedGraphEditPart editPart) {
        this.editPart = editPart;
    }

    public int getWidth() {
        int width = 0;
        IFigure figure = this.editPart.getFigure();
        int figureWidth = figure.getPreferredSize().width;
        if (this.children.size() > 0) {
            if (this.direction == 131072) {
                for (SortedGraphNode child : this.children) {
                    width += child.getWidth();
                }
                width += 30 + (this.children.size() - 1) * 15 * 3 + 30;
            } else {
                width = 0;
                for (SortedGraphNode child : this.children) {
                    int childWidth = child.getWidth();
                    if (childWidth <= width) continue;
                    width = childWidth;
                }
                width += 60;
            }
            if (width < figureWidth) {
                width = figureWidth;
            }
        } else {
            width = figureWidth;
        }
        return width;
    }

    public int getHeight() {
        int height = 0;
        IFigure figure = this.editPart.getFigure();
        int figureHeight = figure.getPreferredSize().height;
        if (this.children.size() > 0) {
            if (this.direction == 1024) {
                for (SortedGraphNode child : this.children) {
                    height += child.getHeight();
                }
                height += 60 + (this.children.size() - 1) * 15 * 3 + 30;
            } else {
                height = 0;
                for (SortedGraphNode child : this.children) {
                    int childheight = child.getHeight();
                    if (childheight <= height) continue;
                    height = childheight;
                }
                if ((height += 90) < figureHeight) {
                    height = figureHeight;
                }
            }
            return height;
        }
        return this.editPart.getFigure().getPreferredSize().height;
    }
}

