/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.layoutmanagers;

import com.ibm.cics.ia.ui.viz.layoutmanagers.EdgeMetric;
import com.ibm.cics.ia.ui.viz.layoutmanagers.SortedGraphNode;
import java.util.LinkedList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class SortedGraphEdge
implements Comparable<SortedGraphEdge> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SortedGraphNode sourceNode;
    private SortedGraphNode targetNode;
    private EdgeMetric edgeMetric;
    private LinkedList<Point> bends = new LinkedList();
    private int anchorDirection;

    public int getAnchorDirection() {
        return this.anchorDirection;
    }

    public void setAnchorDirection(int anchorDirection) {
        this.anchorDirection = anchorDirection;
    }

    public LinkedList<Point> getBends() {
        return this.bends;
    }

    public void setBends(LinkedList<Point> bends) {
        this.bends = bends;
    }

    public SortedGraphEdge(SortedGraphNode sourceNode, SortedGraphNode targetNode) {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.edgeMetric = new EdgeMetric(this);
    }

    public SortedGraphNode getSourceNode() {
        return this.sourceNode;
    }

    public SortedGraphNode getTargetNode() {
        return this.targetNode;
    }

    @Override
    public int compareTo(SortedGraphEdge o) {
        Point thisSourceLocation = this.sourceNode.getLocation();
        Point oSourceLocation = o.sourceNode.getLocation();
        Dimension difference = thisSourceLocation.getDifference(oSourceLocation);
        if (difference.height < 0 || difference.width < 0) {
            return -1;
        }
        return this.edgeMetric.compareTo(o.edgeMetric);
    }
}

