/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.layoutmanagers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsDiagramRootEditPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;

public class GraphLayoutManager
extends AbstractLayout {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(GraphLayoutManager.class.getPackage().getName());
    private ConnectionsDiagramRootEditPart diagram;
    private int direction;
    private int lastLayoutDirection;

    public GraphLayoutManager(ConnectionsDiagramRootEditPart connectionsDiagramRootEditPart) {
        this.diagram = connectionsDiagramRootEditPart;
        this.lastLayoutDirection = -1;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Debug.enter((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"calculatePreferredSize", (Object)("Thread ID: " + Thread.currentThread().getId()));
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        Debug.exit((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"calculatePreferredSize");
        return result.getSize();
    }

    public void layout(IFigure container) {
        Debug.enter((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"layout", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        HashMap<Object, Object> partsToNodes = new HashMap<Object, Object>();
        graph.setDirection(this.direction);
        this.lastLayoutDirection = this.direction;
        this.diagram.contributeNodesToGraph(graph, null, partsToNodes);
        this.diagram.contributeEdgesToGraph(graph, partsToNodes);
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        this.correctSubgraphLayout(partsToNodes);
        this.diagram.applyGraphResults(graph, partsToNodes);
        Debug.exit((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"layout");
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        Debug.enter((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"setDirection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.direction = direction;
        if (this.direction != this.lastLayoutDirection && this.lastLayoutDirection != -1) {
            this.diagram.getFigure().revalidate();
        }
        Debug.exit((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"setDirection");
    }

    public int getLastLayoutDirection() {
        return this.lastLayoutDirection;
    }

    private void correctSubgraphLayout(Map<Object, Object> partsToNodes) {
        Debug.enter((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"correctSubgraphLayout", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Object root = partsToNodes.get((Object)this.diagram);
        this.correctSubgraphLayout(root);
        if (!(root instanceof Node)) {
            return;
        }
        Node rootNode = (Node)root;
        int w = 0;
        int h = 0;
        for (Object o : partsToNodes.values()) {
            if (o == root) continue;
            if (o instanceof Node) {
                Node n = (Node)o;
                w = Math.max(n.x + n.width, w);
                h = Math.max(n.y + n.height, h);
            }
            if (!(o instanceof Edge)) continue;
            Edge e = (Edge)o;
            NodeList nodes = e.vNodes;
            if (nodes == null) continue;
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                w = Math.max(vn.x + vn.width, w);
                h = Math.max(vn.y + vn.height, h);
                ++i;
            }
        }
        rootNode.x = 0;
        rootNode.y = 0;
        rootNode.width = w + 10;
        rootNode.height = h + 10;
        Debug.exit((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"correctSubgraphLayout");
    }

    private void correctSubgraphLayout(Object member) {
        Debug.enter((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"correctSubgraphLayout", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!(member instanceof Subgraph)) {
            Debug.exit((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"correctSubgraphLayout");
            return;
        }
        Subgraph subGraph = (Subgraph)member;
        for (Object o : subGraph.members) {
            this.correctSubgraphLayout(o);
        }
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        int w = 0;
        int h = 0;
        for (Object node : subGraph.members) {
            if (node.getClass() != Node.class && node.getClass() != Subgraph.class) continue;
            Node n = (Node)node;
            x = Math.min(n.x, x);
            y = Math.min(n.y, y);
            w = Math.max(n.x + n.width, w);
            h = Math.max(n.y + n.height, h);
        }
        subGraph.x = x;
        subGraph.y = y;
        subGraph.width = w - x;
        subGraph.height = h - y;
        subGraph.x -= subGraph.innerPadding.left;
        subGraph.y -= subGraph.innerPadding.top;
        subGraph.width += subGraph.innerPadding.left + subGraph.innerPadding.right;
        subGraph.height += subGraph.innerPadding.top + subGraph.innerPadding.bottom;
        Debug.exit((Logger)logger, (String)GraphLayoutManager.class.getName(), (String)"correctSubgraphLayout");
    }
}

