/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.ui.viz.FontFactory;
import com.ibm.cics.ia.ui.viz.figures.IFigureResizeListener;
import com.ibm.cics.ia.ui.viz.figures.ISizeChangingFigure;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TitledImageFigure
extends Figure
implements ISizeChangingFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ImageFigure imageFigure;
    private Label labelFigure;
    private int style;
    private Font font;
    private HashMap<Object, Object> data = new HashMap();
    protected ArrayList<IFigureResizeListener> figureResizeListeners = new ArrayList();
    public static final int DEFAULT_MARGIN = 5;
    public static final int DEFAULT_SPACING = 0;
    private int margin;
    private int spacing;

    public TitledImageFigure(Image image, String text, int style) {
        this(image, text, FontFactory.getInstance().getDefaultFont(), style);
    }

    public TitledImageFigure(Image image, String text, Font font, int style) {
        this(image, text, font, style, 5, 0);
    }

    public TitledImageFigure(Image image, String text, int style, int margin, int spacing) {
        this(image, text, FontFactory.getInstance().getDefaultFont(), style, margin, spacing);
    }

    public TitledImageFigure(Image image, String text, Font font, int style, int margin, int spacing) {
        this.imageFigure = new ImageFigure(image);
        this.labelFigure = new Label(text);
        this.style = style;
        this.font = font;
        this.margin = margin;
        this.spacing = spacing;
        this.labelFigure.setFont(font);
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)this.imageFigure);
        this.add((IFigure)this.labelFigure);
        this.recalculateSize();
    }

    public void recalculateSize() {
        XYLayout layout = (XYLayout)this.getLayoutManager();
        int imageX = this.spacing;
        int imageY = this.spacing;
        int labelX = this.spacing;
        int labelY = this.spacing;
        int imageW = this.imageFigure.getImage().getBounds().width;
        int imageH = this.imageFigure.getImage().getBounds().height;
        TextUtilities utilities = this.labelFigure.getTextUtilities();
        Dimension labelSize = utilities.getTextExtents(this.labelFigure.getText(), this.font);
        int labelH = labelSize.height;
        int labelW = labelSize.width;
        int totalHeight = 0;
        int totalWidth = 0;
        switch (this.style) {
            default: {
                labelX = imageX + this.margin + imageW;
                labelY = imageY + (imageH - labelH) / 2;
                totalWidth = this.spacing + imageW + this.margin + labelW + this.spacing;
                totalHeight = imageH > labelH ? imageH : labelH;
                totalHeight += this.spacing * 2;
                break;
            }
            case 131072: {
                imageX = labelX + this.margin + labelW;
                labelY = imageY + (imageH - labelH) / 2;
                totalWidth = this.spacing + imageW + this.margin + labelW + this.spacing;
                totalHeight = imageH > labelH ? imageH : labelH;
                totalHeight += this.spacing * 2;
                break;
            }
            case 128: {
                labelY = imageY + this.margin + imageH;
                totalHeight = this.spacing + imageH + this.margin + labelH + this.spacing;
                totalWidth = imageW > labelW ? imageW : labelW;
                totalWidth += this.spacing * 2;
                break;
            }
            case 1024: {
                imageY = labelY + this.margin + labelH;
                totalHeight = this.spacing + imageH + this.margin + labelH + this.spacing;
                totalWidth = imageW > labelW ? imageW : labelW;
                totalWidth += this.spacing * 2;
            }
        }
        layout.setConstraint((IFigure)this.imageFigure, (Object)new Rectangle(imageX, imageY, imageW, imageH));
        layout.setConstraint((IFigure)this.labelFigure, (Object)new Rectangle(labelX, labelY, labelW, labelH));
        this.setPreferredSize(new Dimension(totalWidth, totalHeight));
        this.setMinimumSize(new Dimension(totalWidth, totalHeight));
        this.setMaximumSize(new Dimension(totalWidth, totalHeight));
        for (IFigureResizeListener listener : this.figureResizeListeners) {
            listener.onFigureResized(this);
        }
    }

    public void setText(String text) {
        this.labelFigure.setText(text);
        this.recalculateSize();
    }

    public void setData(Object value) {
        this.data.put(null, value);
    }

    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    public Object getData() {
        return this.data.get(null);
    }

    public Object getData(Object key) {
        return this.data.get(key);
    }

    @Override
    public void addResizeListener(IFigureResizeListener listener) {
        this.figureResizeListeners.add(listener);
    }

    @Override
    public void removeResizeListener(IFigureResizeListener listener) {
        this.figureResizeListeners.remove(listener);
    }

    public String getLabel() {
        return this.labelFigure.getText();
    }
}

