/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.ui.viz.figures.BorderedFigure;
import com.ibm.cics.ia.ui.viz.figures.IFigureResizeListener;
import com.ibm.cics.ia.ui.viz.figures.ISizeChangingFigure;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class TitledContainerFigure
extends BorderedFigure
implements ISizeChangingFigure,
IFigureResizeListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected IFigure titleFigure;
    protected IFigure contentFigure;
    protected int margin;
    protected static final int DEFAULT_MARGIN = 10;
    protected ArrayList<IFigureResizeListener> figureResizeListeners = new ArrayList();
    private HashMap<Object, Object> data = new HashMap();

    public TitledContainerFigure() {
        this(10);
    }

    public TitledContainerFigure(int margin) {
        this.margin = margin;
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
    }

    public void setContent(IFigure figure) {
        if (this.contentFigure != null) {
            this.remove(this.contentFigure);
        }
        this.contentFigure = figure;
        Point contentLoc = this.getContentLocation();
        Rectangle childBounds = new Rectangle(contentLoc, figure.getPreferredSize());
        this.add(figure, childBounds);
        this.setPreferredSize(this.calculateSize());
        if (figure instanceof ISizeChangingFigure) {
            ((ISizeChangingFigure)figure).addResizeListener(this);
        }
        this.figureResized();
    }

    public void setTitleFigure(IFigure newFigure) {
        if (this.titleFigure != null) {
            this.remove(this.titleFigure);
        }
        this.titleFigure = newFigure;
        this.add(this.titleFigure, new Rectangle(new Point(this.margin, this.margin), this.titleFigure.getPreferredSize()));
        if (newFigure instanceof ISizeChangingFigure) {
            ((ISizeChangingFigure)newFigure).addResizeListener(this);
        }
    }

    protected void figureResized() {
        LayoutManager mgr;
        IFigure parent;
        Dimension size = this.calculateSize();
        Rectangle bounds = this.getBounds().getCopy();
        bounds.setSize(size);
        this.setBounds(bounds);
        if (this.contentFigure != null) {
            Point contentLoc = this.getContentLocation();
            Rectangle contentBounds = new Rectangle(contentLoc, this.contentFigure.getPreferredSize());
            this.getLayoutManager().setConstraint(this.contentFigure, (Object)contentBounds);
        }
        if ((parent = this.getParent()) != null && (mgr = parent.getLayoutManager()) != null && mgr.getConstraint((IFigure)this) != null) {
            Rectangle constraint = ((Rectangle)mgr.getConstraint((IFigure)this)).getCopy();
            constraint.setSize(this.getPreferredSize());
            mgr.setConstraint((IFigure)this, (Object)constraint);
        }
        for (IFigureResizeListener listener : this.figureResizeListeners) {
            listener.onFigureResized(this);
        }
    }

    public IFigure getContentFigure() {
        return this.contentFigure;
    }

    protected Point getContentLocation() {
        int posX = this.margin;
        int titleHeight = this.titleFigure.getPreferredSize().height;
        int posY = this.margin + titleHeight + this.margin;
        return new Point(posX, posY);
    }

    protected Dimension calculateSize() {
        Dimension result = new Dimension(this.margin * 2, this.margin * 2);
        if (this.titleFigure != null) {
            result.width += this.titleFigure.getPreferredSize().width;
            result.height += this.titleFigure.getPreferredSize().height;
        }
        if (this.contentFigure != null) {
            if (this.margin + this.contentFigure.getPreferredSize().width + this.margin > result.width) {
                result.width = this.margin + this.contentFigure.getPreferredSize().width + this.margin;
            }
            result.height = result.height + this.contentFigure.getPreferredSize().height + this.margin;
        }
        this.setPreferredSize(result);
        this.setMaximumSize(result);
        this.setMinimumSize(result);
        return result;
    }

    public void setData(Object value) {
        this.data.put(null, value);
    }

    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    public Object getData() {
        return this.data.get(null);
    }

    public Object getData(Object key) {
        return this.data.get(key);
    }

    @Override
    public void addResizeListener(IFigureResizeListener listener) {
        this.figureResizeListeners.add(listener);
    }

    @Override
    public void removeResizeListener(IFigureResizeListener listener) {
        this.figureResizeListeners.remove(listener);
    }

    @Override
    public void onFigureResized(ISizeChangingFigure resizedFigure) {
        this.figureResized();
    }
}

