/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.ProgramNode;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.TypeColorFactory;
import com.ibm.cics.ia.ui.viz.figures.BorderedFigure;
import com.ibm.cics.ia.ui.viz.figures.TitledImageFigure;
import com.ibm.cics.ia.ui.viz.figures.TooltipFigure;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class ResourceFigure
extends BorderedFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected INode resourceNode;
    protected int margin;
    public static final int DEFAULT_MARGIN = 8;
    protected int maxLength;
    public static final int DEFAULT_MAX_LENGTH = 16;
    protected TitledImageFigure titleFigure;

    public ResourceFigure(INode resourceNode) {
        this(resourceNode, 8, 16);
    }

    public ResourceFigure(INode resourceNode, int margin, int maxLength) {
        String name;
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.margin = margin;
        this.maxLength = maxLength;
        Resource resource = (Resource)resourceNode.getObject();
        Image image = null;
        image = resourceNode instanceof ProgramNode && ((ProgramNode)resourceNode).isOperationCandidate() ? ImageFactory.getOperationCandidateImage() : ResourceRenderer.asImage(resource);
        StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(((Resource)resourceNode.getObject()).getTypeName()));
        sb.append(" (");
        String truncatedName = name = ResourceRenderer.asText((Resource)resourceNode.getObject());
        if (name.length() > maxLength) {
            truncatedName = String.valueOf(name.substring(0, maxLength)) + "...";
            TooltipFigure tooltipFigure = new TooltipFigure();
            tooltipFigure.setMessage(String.valueOf(sb.toString()) + name + ")");
            this.setToolTip((IFigure)tooltipFigure);
        }
        sb.append(truncatedName);
        sb.append(")");
        String text = sb.toString();
        this.titleFigure = new TitledImageFigure(image, text, 16384);
        this.borderColorSelected = TypeColorFactory.getColor(resource, true);
        this.borderColorDeselected = TypeColorFactory.getColor(resource, false);
        this.add((IFigure)this.titleFigure, new Rectangle(new Point(8, 8), this.titleFigure.getPreferredSize()));
        int width = this.titleFigure.getPreferredSize().width;
        int height = this.titleFigure.getPreferredSize().height;
        Dimension size = new Dimension(width + 16, height + 16);
        this.setPreferredSize(size);
    }

    public INode getResourceNode() {
        return this.resourceNode;
    }

    public Figure getTitleFigure() {
        return this.titleFigure;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setOpacity(int alpha) {
        this.currentAlpha = alpha;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        graphics.setAlpha(this.currentAlpha);
        Rectangle r = this.getBounds();
        Rectangle patternRec = r.getCopy();
        this.translateToAbsolute((Translatable)patternRec);
        if (this.selected) {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Selected, this.backgroundColor2Selected));
        } else {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Deselected, this.backgroundColor2Deselected));
        }
        graphics.fillRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 4, r.height - 4), 5, 5);
        if (this.selected) {
            graphics.setLineWidth(2);
            graphics.setForegroundColor(this.borderColorSelected);
        } else {
            graphics.setLineWidth(1);
            graphics.setForegroundColor(this.borderColorDeselected);
        }
        graphics.setAlpha(this.currentAlpha / 4);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2), 7, 7);
        graphics.setAlpha(this.currentAlpha / 2);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 3, r.height - 3), 6, 6);
        graphics.setForegroundColor(this.textColor);
        graphics.setAlpha(this.currentAlpha);
        super.paint(graphics);
    }
}

