/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.TypeColorFactory;
import com.ibm.cics.ia.ui.viz.figures.BorderedFigure;
import com.ibm.cics.ia.ui.viz.figures.TitledImageFigure;
import com.ibm.cics.ia.ui.viz.figures.TooltipFigure;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class NestedResourceFigure
extends BorderedFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private INestedNode resourceNode;
    protected int maxLength;
    public static final int DEFAULT_MAX_LENGTH = 16;
    private TitledImageFigure titleFigure;

    public NestedResourceFigure(INestedNode resourceNode) {
        this(resourceNode, 16);
    }

    public NestedResourceFigure(INestedNode resourceNode, int maxLength) {
        String name;
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.resourceNode = resourceNode;
        this.maxLength = maxLength;
        Resource resource = (Resource)resourceNode.getObject();
        Image image = ResourceRenderer.asImage(resource);
        StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(((Resource)resourceNode.getObject()).getTypeName()));
        sb.append(" (");
        String truncatedName = name = ResourceRenderer.asText((Resource)resourceNode.getObject());
        if (name.length() > maxLength) {
            truncatedName = String.valueOf(name.substring(0, maxLength)) + "...";
            TooltipFigure tooltipFigure = new TooltipFigure();
            tooltipFigure.setMessage(String.valueOf(sb.toString()) + name + ")");
            this.setToolTip((IFigure)tooltipFigure);
        }
        sb.append(truncatedName);
        sb.append(")");
        String text = sb.toString();
        this.titleFigure = new TitledImageFigure(image, text, 16384);
        this.borderColorSelected = TypeColorFactory.getColor(resource, true);
        this.borderColorDeselected = TypeColorFactory.getColor(resource, false);
        this.add((IFigure)this.titleFigure);
    }

    public void setOpacity(int alpha) {
        this.currentAlpha = alpha;
        this.repaint();
    }

    public Figure getTitleFigure() {
        return this.titleFigure;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        Rectangle r = this.getBounds();
        Rectangle patternRec = r.getCopy();
        this.translateToAbsolute((Translatable)patternRec);
        graphics.setAlpha(this.currentAlpha);
        if (this.selected) {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Selected, this.backgroundColor2Selected));
        } else {
            graphics.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(patternRec.x + patternRec.width / 2), (float)r.y, (float)(patternRec.x + patternRec.width / 2), (float)(r.y + patternRec.height), this.backgroundColor1Deselected, this.backgroundColor2Deselected));
        }
        graphics.fillRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 4, r.height - 4), 5, 5);
        graphics.setBackgroundColor(new Color((Device)Display.getDefault(), 208, 223, 238));
        graphics.fillRectangle(new Rectangle(r.x + 2, r.y + 2, r.width - 5, 24));
        graphics.setLineWidth(1);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 236, 244, 252));
        graphics.drawLine(r.x + 1, r.y + 2, r.x + r.width - 4, r.y + 2);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 229, 239, 249));
        graphics.drawLine(r.x + 1, r.y + 3, r.x + r.width - 4, r.y + 3);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 222, 234, 245));
        graphics.drawLine(r.x + 1, r.y + 4, r.x + r.width - 4, r.y + 4);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 215, 229, 242));
        graphics.drawLine(r.x + 1, r.y + 5, r.x + r.width - 4, r.y + 5);
        graphics.setForegroundColor(new Color((Device)Display.getDefault(), 162, 168, 184));
        graphics.drawLine(r.x + 2, r.y + 27, r.x + r.width - 4, r.y + 27);
        if (this.selected) {
            graphics.setLineWidth(2);
            graphics.setForegroundColor(this.borderColorSelected);
        } else {
            graphics.setLineWidth(1);
            graphics.setForegroundColor(this.borderColorDeselected);
        }
        graphics.setAlpha(this.currentAlpha / 4);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2), 7, 7);
        graphics.setAlpha(this.currentAlpha / 2);
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 3, r.height - 3), 6, 6);
        graphics.setForegroundColor(this.textColor);
        super.paint(graphics);
    }
}

