/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.TypeColorFactory;
import com.ibm.cics.ia.ui.viz.figures.GridFigure;
import com.ibm.cics.ia.ui.viz.figures.TitledExpandableFigure;
import com.ibm.cics.ia.ui.viz.figures.TitledImageFigure;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;

public class NestedResourceExpandableFigure
extends TitledExpandableFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private INestedNode resourceNode;
    private GridFigure summaryContainerFigure;
    private HashMap<String, TitledImageFigure> resourceTypeSummary = new HashMap();

    public NestedResourceExpandableFigure(INestedNode resourceNode) {
        super(10);
        this.resourceNode = resourceNode;
        GridFigure topFigure = new GridFigure(1, 5, 0);
        StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(((Resource)resourceNode.getObject()).getTypeName()));
        sb.append(" (");
        sb.append(ResourceRenderer.asText((Resource)resourceNode.getObject()));
        sb.append(")");
        String name = sb.toString();
        this.borderColorSelected = TypeColorFactory.getColor((Resource)resourceNode.getObject(), true);
        this.borderColorDeselected = TypeColorFactory.getColor((Resource)resourceNode.getObject(), false);
        TitledImageFigure topTitle = new TitledImageFigure(ResourceRenderer.asImage((Resource)resourceNode.getObject()), name, 16384);
        topFigure.add((IFigure)topTitle);
        this.summaryContainerFigure = new GridFigure(10, 5, 0);
        topFigure.add((IFigure)this.summaryContainerFigure);
        this.setTitleFigure((IFigure)topFigure);
        GridFigure contentFigure = new GridFigure(3, 10, 0);
        this.setContent(contentFigure);
    }

    public void updateSummaries() {
        this.resourceTypeSummary.clear();
        this.updateSummaries(this.resourceNode);
        for (TitledImageFigure figure : this.resourceTypeSummary.values()) {
            int data = (Integer)figure.getData();
            figure.setText("(" + Integer.toString(data) + ")");
        }
    }

    private void updateSummaries(INestedNode resourceNode) {
        Set children = resourceNode.getChildren().entrySet();
        for (Map.Entry child : children) {
            TitledImageFigure summaryFigure = this.resourceTypeSummary.get(((Resource)child.getKey()).getTypeName());
            if (summaryFigure == null) {
                summaryFigure = new TitledImageFigure(ResourceRenderer.asImage(child.getKey()), "(0)", 16384);
                summaryFigure.setData(0);
                this.resourceTypeSummary.put(((Resource)child.getKey()).getTypeName(), summaryFigure);
                this.summaryContainerFigure.add((IFigure)summaryFigure);
            }
            int data = (Integer)summaryFigure.getData();
            summaryFigure.setData(++data);
            if (!(child.getValue() instanceof INestedNode)) continue;
            this.updateSummaries((INestedNode)child.getValue());
        }
    }
}

