/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.viz.CommandNode;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import com.ibm.cics.ia.ui.viz.figures.TooltipFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.swt.graphics.Color;

public class CommandConnectionFigure
extends PolylineConnection
implements ISelectableFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean selected = false;
    private NodeConnection resourceNodeConnection;

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        if (this.selected) {
            this.setLineWidthFloat(3.0f);
            this.setAlpha(255);
        } else {
            this.setLineWidthFloat(2.0f);
            this.setAlpha(160);
        }
        super.paint(graphics);
    }

    public CommandConnectionFigure(NodeConnection resourceNodeConnection) {
        this.resourceNodeConnection = resourceNodeConnection;
        StringBuilder verbNames = new StringBuilder();
        ArrayList verbs = resourceNodeConnection.getVerbs();
        String sourceName = IAUtilities.EMPTY_STRING;
        String targetName = IAUtilities.EMPTY_STRING;
        sourceName = ResourceRenderer.asVerb(((CommandExecution)((CommandNode)resourceNodeConnection.getSource()).getObject()).getResourceAndVerb().getVerb(), ((CommandExecution)((CommandNode)resourceNodeConnection.getSource()).getObject()).getResourceAndVerb().getType());
        targetName = ResourceRenderer.asVerb(((CommandExecution)((CommandNode)resourceNodeConnection.getTarget()).getObject()).getResourceAndVerb().getVerb(), ((CommandExecution)((CommandNode)resourceNodeConnection.getTarget()).getObject()).getResourceAndVerb().getType());
        TooltipFigure tooltipFigure = new TooltipFigure();
        tooltipFigure.setMessage(String.valueOf(sourceName) + " -> " + targetName);
        this.setToolTip((IFigure)tooltipFigure);
        this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        this.setForegroundColor(this.getColor());
    }

    public Color getColor() {
        Color result = ColorConstants.darkGray;
        return result;
    }
}

