/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.figures;

import com.ibm.cics.ia.ui.viz.FontFactory;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class BorderedFigure
extends Figure
implements ISelectableFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Color textColor = DEFAULT_TEXT_COLOR;
    protected Color borderColorSelected = DEFAULT_BORDER_COLOR_SELECTED;
    protected Color borderColorDeselected = DEFAULT_BORDER_COLOR_DESELECTED;
    protected Color backgroundColor1Deselected = DEFAULT_BACKGROUND_COLOR_1_DESELECTED;
    protected Color backgroundColor2Deselected = DEFAULT_BACKGROUND_COLOR_2_DESELECTED;
    protected Color backgroundColor1Selected = DEFAULT_BACKGROUND_COLOR_1_SELECTED;
    protected Color backgroundColor2Selected = DEFAULT_BACKGROUND_COLOR_2_SELECTED;
    protected static Color DEFAULT_TEXT_COLOR = ColorConstants.black;
    protected static Color DEFAULT_BORDER_COLOR_DESELECTED = ColorConstants.gray;
    protected static Color DEFAULT_BORDER_COLOR_SELECTED = ColorConstants.darkGray;
    protected static Color DEFAULT_BACKGROUND_COLOR_1_DESELECTED = ColorConstants.white;
    protected static Color DEFAULT_BACKGROUND_COLOR_2_DESELECTED = new Color(null, 230, 230, 230);
    protected static Color DEFAULT_BACKGROUND_COLOR_1_SELECTED = ColorConstants.white;
    protected static Color DEFAULT_BACKGROUND_COLOR_2_SELECTED = new Color(null, 210, 210, 210);
    protected boolean selected;
    protected int currentAlpha = 255;

    public BorderedFigure() {
        this.setFont(FontFactory.getInstance().getDefaultFont());
    }

    public void paint(Graphics graphics) {
        graphics.setAntialias(1);
        Rectangle r = this.getBounds();
        graphics.setAlpha(this.currentAlpha);
        if (this.selected) {
            graphics.setLineWidth(2);
            graphics.setForegroundColor(this.borderColorSelected);
        } else {
            graphics.setLineWidth(1);
            graphics.setForegroundColor(this.borderColorDeselected);
        }
        graphics.drawRoundRectangle(new Rectangle(r.x + 1, r.y + 1, r.width - 4, r.height - 4), 5, 5);
        graphics.setForegroundColor(this.textColor);
        super.paint(graphics);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }
}

