/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.RootNode;
import com.ibm.cics.ia.ui.viz.editparts.SortedGraphEditPart;
import com.ibm.cics.ia.ui.viz.figures.TimelineFigure;
import com.ibm.cics.ia.ui.viz.layoutmanagers.TimelineGraphLayoutManager;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class SortedGraphRootEditPart
extends SortedGraphEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean isStale;
    private TimelineGraphLayoutManager layoutManager;

    public SortedGraphRootEditPart(RootNode rootNode) {
        super((INode)rootNode);
        TimelineGraphLayoutManager mgr;
        this.layoutManager = mgr = new TimelineGraphLayoutManager(this);
        this.setStale(false);
    }

    public void setDirection(int direction) {
        this.layoutManager.setDirection(direction);
    }

    @Override
    protected List getModelChildren() {
        RootNode node = (RootNode)this.getModel();
        INode[] array = node.getChildren().values().toArray(new INode[0]);
        return Arrays.asList(array);
    }

    public boolean isStale() {
        return this.isStale;
    }

    public void setStale(boolean stale) {
        this.isStale = stale;
        if (stale) {
            this.refreshVisuals();
        }
    }

    @Override
    protected IFigure createFigure() {
        TimelineFigure f = new TimelineFigure();
        RootNode root = (RootNode)this.getModel();
        f.setTimelineColumnName(root.getObject().toString());
        f.setLayoutManager(this.layoutManager);
        return f;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("ComponentEditPolicy");
    }
}

