/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.CommandExecution;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceAndVerb;
import com.ibm.cics.ia.model.TimeLineRowObject;
import com.ibm.cics.ia.model.viz.CommandNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.anchors.GraphInOutAnchor;
import com.ibm.cics.ia.ui.viz.editparts.Messages;
import com.ibm.cics.ia.ui.viz.editparts.SortedGraphEditPart;
import com.ibm.cics.ia.ui.viz.figures.CommandFigure;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;

public class SortedGraphNodeEditPart
extends SortedGraphEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final DateFormat dateFormat = new SimpleDateFormat("hh:mm:ss.SSS");
    private GraphInOutAnchor sourceAnchor;
    private GraphInOutAnchor targetAnchor;

    @Override
    protected List getModelChildren() {
        return new ArrayList();
    }

    protected List getModelSourceConnections() {
        INode model = (INode)this.getModel();
        return model.getOutgoingConnections();
    }

    protected List getModelTargetConnections() {
        INode model = (INode)this.getModel();
        return model.getIncomingConnections();
    }

    public SortedGraphNodeEditPart(INode model) {
        super(model);
        if (model instanceof CommandNode) {
            CommandNode commandNode = (CommandNode)model;
            CommandExecution commandExecution = (CommandExecution)commandNode.getObject();
            ResourceAndVerb resourceAndVerb = commandExecution.getResourceAndVerb();
            Resource resource = resourceAndVerb.getResource();
            StringBuilder sb = new StringBuilder(resourceAndVerb.getVerb().toLowerCase());
            sb.append(" ");
            sb.append(ResourceTypeRenderer.asText(resource.getTypeName()));
            sb.append(" ");
            sb.append(ResourceRenderer.asText(resource));
            Object rowObject = commandNode.getTimeLineRowObject();
            String rowObjectString = IAUtilities.EMPTY_STRING;
            if (rowObject instanceof TimeLineRowObject) {
                rowObjectString = rowObject.toString();
            } else if (rowObject instanceof Resource) {
                resource = (Resource)rowObject;
                StringBuilder sb2 = new StringBuilder(resource.getTypeName());
                sb2.append(" ");
                sb2.append(ResourceRenderer.asText(resource));
                rowObjectString = sb2.toString();
            } else {
                rowObjectString = MessageFormat.format(Messages.getString("CommandFlowDiagramEditPart.Accessible.TCBModeRow"), rowObject);
            }
            this.accessibleName = MessageFormat.format(Messages.getString("CommandFlowDiagramEditPart.Accessible.CommandNode"), sb.toString(), rowObjectString, dateFormat.format(commandExecution.getCommandTime()));
        }
    }

    @Override
    protected IFigure createFigure() {
        INode resourceAndVerbNode = (INode)this.getModel();
        return new CommandFigure(resourceAndVerbNode);
    }

    @Override
    protected void createEditPolicies() {
        NonResizableEditPolicy policy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ((ISelectableFigure)SortedGraphNodeEditPart.this.getFigure()).setSelected(true);
            }

            protected void hideSelection() {
                ((ISelectableFigure)SortedGraphNodeEditPart.this.getFigure()).setSelected(false);
            }
        };
        policy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        policy.activate();
    }

    @Override
    public void setFigureSelected(boolean selected) {
        ((CommandFigure)this.getFigure()).setSelected(selected);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("Selection Feedback");
    }
}

