/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.CommandNode;
import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.viz.editparts.Messages;
import com.ibm.cics.ia.ui.viz.figures.CommandConnectionFigure;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import com.ibm.cics.ia.ui.viz.layoutmanagers.SortedGraphEdge;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class SortedGraphEdgeEditPart
extends AbstractConnectionEditPart
implements IModelChangeListener<NodeConnection> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected AccessibleEditPart accessibleEditPart;
    protected String accessibleName;

    public SortedGraphEdgeEditPart(NodeConnection model) {
        this.setModel(model);
        CommandNode commandNode = (CommandNode)model.getTarget();
        Object rowObject = commandNode.getTimeLineRowObject();
        String rowObjectString = IAUtilities.EMPTY_STRING;
        if (rowObject instanceof Resource) {
            Resource resource = (Resource)rowObject;
            StringBuilder sb2 = new StringBuilder(resource.getTypeName());
            sb2.append(" ");
            sb2.append(ResourceRenderer.asText(resource));
            rowObjectString = sb2.toString();
        } else if (rowObject instanceof String) {
            rowObjectString = MessageFormat.format(Messages.getString("CommandFlowDiagramEditPart.Accessible.TCBModeRow"), rowObject);
        }
        this.accessibleName = MessageFormat.format(Messages.getString("CommandFlowDiagramEditPart.Accessible.Connection"), rowObjectString);
        model.addModelChangeListener((IModelChangeListener)this);
    }

    public void setFigureSelected(boolean selected) {
        IFigure figure = this.getFigure();
        if (figure instanceof CommandConnectionFigure) {
            ((CommandConnectionFigure)this.getFigure()).setSelected(selected);
        }
    }

    protected IFigure createFigure() {
        NodeConnection model = (NodeConnection)this.getModel();
        CommandConnectionFigure conn = new CommandConnectionFigure((NodeConnection)this.getModel());
        conn.setVisible(false);
        return conn;
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy policy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ((ISelectableFigure)SortedGraphEdgeEditPart.this.getFigure()).setSelected(true);
            }

            protected void hideSelection() {
                ((ISelectableFigure)SortedGraphEdgeEditPart.this.getFigure()).setSelected(false);
            }
        };
        policy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        policy.activate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

            public void getName(AccessibleEvent e) {
                e.result = SortedGraphEdgeEditPart.this.accessibleName;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }

    public void applyGraphResuts(Map<SortedGraphEdgeEditPart, SortedGraphEdge> editPartsToEdges) {
        PolylineConnection conn = (PolylineConnection)this.getConnectionFigure();
        SortedGraphEdge e = editPartsToEdges.get((Object)this);
        if (e == null) {
            conn.setVisible(false);
            return;
        }
        conn.setVisible(true);
        Point sourceLocation = e.getBends().pollFirst();
        Point targetLocation = e.getBends().pollLast();
        if (e.getBends().size() > 0) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            for (Point point : e.getBends()) {
                bends.add(new AbsoluteBendpoint(point));
            }
            conn.setSourceAnchor((ConnectionAnchor)new XYAnchor(sourceLocation));
            conn.setTargetAnchor((ConnectionAnchor)new XYAnchor(targetLocation));
            conn.setRoutingConstraint(bends);
        } else {
            conn.setSourceAnchor((ConnectionAnchor)new XYAnchor(sourceLocation));
            conn.setTargetAnchor((ConnectionAnchor)new XYAnchor(targetLocation));
        }
        conn.getConnectionRouter().route((Connection)conn);
        PolygonDecoration decoration = new PolygonDecoration();
    }

    public void onModelChanged(NodeConnection model) {
        this.setFigureSelected(model.isSelected());
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("Selection Feedback");
    }
}

