/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.DB2Resource;
import com.ibm.cics.ia.model.IMSResource;
import com.ibm.cics.ia.model.MQResource;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.model.viz.ResourceFilter;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.ShowDetailsStrategy;
import com.ibm.cics.ia.ui.viz.anchors.GraphInOutAnchor;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsGraphEditPart;
import com.ibm.cics.ia.ui.viz.figures.ISelectableFigure;
import com.ibm.cics.ia.ui.viz.figures.ResourceFigure;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class ResourceNodeGraphEditPart
extends ConnectionsGraphEditPart
implements IModelChangeListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GraphInOutAnchor sourceAnchor;
    private GraphInOutAnchor targetAnchor;
    private ResourceFilter resourceFilter;
    private AccessibleEditPart accessibleEditPart;
    private String accessibleName;

    protected List getModelSourceConnections() {
        INode model = (INode)this.getModel();
        return model.getOutgoingConnections();
    }

    protected List getModelTargetConnections() {
        INode model = (INode)this.getModel();
        return model.getIncomingConnections();
    }

    public ResourceNodeGraphEditPart(INode resourceNode, ResourceFilter rootFilter) {
        this.setModel(resourceNode);
        Resource resource = (Resource)resourceNode.getObject();
        StringBuilder sb = new StringBuilder(ResourceTypeRenderer.asText(resource.getTypeName()));
        sb.append(" ");
        sb.append(ResourceRenderer.asText(resource));
        this.accessibleName = sb.toString();
        if (!IAUtilities.hasContent((String)resource.getTypeName())) {
            this.resourceFilter = rootFilter.getFilter(ResourceFilter.EMPTY);
        } else if (resource instanceof Program) {
            this.resourceFilter = rootFilter.getFilter("PROGRAM");
            this.setVisibility(this.resourceFilter.isChecked());
        } else if (resource instanceof Transaction) {
            this.resourceFilter = rootFilter.getFilter("TRANSID");
            this.setVisibility(this.resourceFilter.isChecked());
        } else {
            this.resourceFilter = resource instanceof DB2Resource ? rootFilter.getFilter(ResourceFilter.DB2).getFilter(resource.getTypeName()) : (resource instanceof IMSResource ? rootFilter.getFilter(ResourceFilter.IMS).getFilter(resource.getTypeName()) : (resource instanceof MQResource ? rootFilter.getFilter(ResourceFilter.MQ).getFilter(resource.getTypeName()) : rootFilter.getFilter(ResourceFilter.CICS).getFilter(resource.getTypeName())));
        }
        if (this.resourceFilter != null) {
            this.setVisibility(this.resourceFilter.isChecked());
            this.resourceFilter.addModelChangeListener((IModelChangeListener)this);
        }
    }

    protected IFigure createFigure() {
        INode resourceNode = (INode)this.getModel();
        return new ResourceFigure(resourceNode);
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy policy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ((ISelectableFigure)ResourceNodeGraphEditPart.this.getFigure()).setSelected(true);
                ResourceNodeGraphEditPart.this.setIncomingConnectionsSelected(true);
                ResourceNodeGraphEditPart.this.setOutgoingConnectionsSelected(true);
            }

            protected void hideSelection() {
                ((ISelectableFigure)ResourceNodeGraphEditPart.this.getFigure()).setSelected(false);
                ResourceNodeGraphEditPart.this.setIncomingConnectionsSelected(false);
                ResourceNodeGraphEditPart.this.setOutgoingConnectionsSelected(false);
            }
        };
        policy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        policy.activate();
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = ResourceNodeGraphEditPart.this.accessibleName;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }

    public void setIncomingConnectionsSelected(boolean selected) {
        List incomingConnections = ((INode)this.getModel()).getIncomingConnections();
        if (incomingConnections == null || incomingConnections.isEmpty()) {
            return;
        }
        for (NodeConnection incomingConnection : incomingConnections) {
            if (incomingConnection.isSelected() == selected) continue;
            incomingConnection.setSelected(selected);
        }
    }

    public void setOutgoingConnectionsSelected(boolean selected) {
        List outgoingConnections = ((INode)this.getModel()).getOutgoingConnections();
        if (outgoingConnections == null || outgoingConnections.isEmpty()) {
            return;
        }
        for (NodeConnection outgoingConnection : outgoingConnections) {
            if (outgoingConnection.isSelected() == selected) continue;
            outgoingConnection.setSelected(selected);
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart arg0) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new GraphInOutAnchor(this.getFigure(), -1, false);
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request arg0) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new GraphInOutAnchor(this.getFigure(), -1, false);
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart arg0) {
        if (this.targetAnchor == null) {
            this.targetAnchor = new GraphInOutAnchor(this.getFigure(), -1, true);
        }
        return this.targetAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request arg0) {
        if (this.targetAnchor == null) {
            this.targetAnchor = new GraphInOutAnchor(this.getFigure(), -1, true);
        }
        return this.targetAnchor;
    }

    public void setFigureSelected(boolean selected) {
        ((ResourceFigure)this.getFigure()).setSelected(selected);
    }

    public void onModelChanged(Object model) {
        if (model instanceof ResourceFilter) {
            this.setVisibility(((ResourceFilter)model).isChecked());
        }
    }

    @Override
    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map<Object, Object> map) {
        if (this.sourceAnchor != null) {
            this.sourceAnchor.setOrientation(this.getGraphDirection());
        }
        if (this.targetAnchor != null) {
            this.targetAnchor.setOrientation(this.getGraphDirection());
        }
        super.contributeNodesToGraph(graph, s, map);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeEditPolicy("Selection Feedback");
        if (this.resourceFilter != null) {
            this.resourceFilter.removeModelChangeListener((IModelChangeListener)this);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            Object source = ((INode)this.getModel()).getObject();
            ShowDetailsStrategy.showDetails(source);
        }
    }

    @Override
    public void filterOut(String text) {
        super.filterOut(text);
        if (this.accessibleName != null && !this.accessibleName.matches(text)) {
            ((ResourceFigure)this.getFigure()).setOpacity(96);
        } else {
            ((ResourceFigure)this.getFigure()).setOpacity(255);
        }
    }
}

