/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.ui.viz.editparts.ConnectionsDiagramRootEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsEdgeEditPart;
import com.ibm.cics.ia.ui.viz.editparts.NestedResourceGraphNodeEditPart;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class ConnectionsGraphEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Insets SOUTHPADDING = new Insets(45, 15, 45, 15);
    static final Insets EASTPADDING = new Insets(15, 45, 15, 45);
    static final Insets SOUTHSUBPADDING = new Insets(45, 15, 45, 15);
    static final Insets EASTSUBPADDING = new Insets(15, 45, 15, 45);
    static final Insets SOUTH_INNER_PADDING = new Insets(50, 40, 30, 30);
    static final Insets EAST_INNER_PADDING = new Insets(50, 40, 30, 30);
    private static final Rectangle zeroRectangle = new Rectangle(0, 0, 0, 0);

    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map<Object, Object> map) {
        if (!this.isVisible()) {
            return;
        }
        if (this.getChildren().isEmpty() || !this.hasVisibleChildren()) {
            Node n = new Node((Object)this, s);
            n.outgoingOffset = 5;
            n.incomingOffset = 5;
            if (this.getFigure().getLayoutManager() != null) {
                n.width = this.getFigure().getPreferredSize().width;
                n.height = this.getFigure().getPreferredSize().height;
            } else {
                int w = 0;
                int h = 0;
                for (Object o : this.getFigure().getChildren()) {
                    Figure f;
                    if (o instanceof Label) {
                        Label l = (Label)o;
                        if (!l.isVisible()) continue;
                        w += l.getTextBounds().width;
                        h = Math.max(h, l.getTextBounds().height);
                        continue;
                    }
                    if (!(o instanceof Figure) || !(f = (Figure)o).isVisible()) continue;
                    w += f.getBounds().width;
                    h += Math.max(h, f.getBounds().height);
                }
                n.width = w += 15;
                n.height = h += 10;
            }
            if (this.getGraphDirection() == 16) {
                n.setPadding(EASTPADDING);
                n.setRowConstraint(this.getFigure().getBounds().y);
            } else {
                n.setPadding(SOUTHPADDING);
                n.setRowConstraint(this.getFigure().getBounds().x);
            }
            map.put((Object)this, n);
            graph.nodes.add((Object)n);
        } else {
            Subgraph sg = new Subgraph((Object)this, s);
            sg.outgoingOffset = 5;
            sg.incomingOffset = 5;
            sg.width = -1;
            sg.height = -1;
            if (this.getGraphDirection() == 16) {
                sg.setPadding(EASTSUBPADDING);
                sg.innerPadding = EAST_INNER_PADDING;
                sg.setRowConstraint(this.getFigure().getBounds().y);
            } else {
                sg.setPadding(SOUTHSUBPADDING);
                sg.innerPadding = SOUTH_INNER_PADDING;
                sg.setRowConstraint(this.getFigure().getBounds().x);
            }
            map.put((Object)this, sg);
            graph.nodes.add((Object)sg);
            int i = 0;
            while (i < this.getChildren().size()) {
                if (this.getChildren().get(i) instanceof ConnectionsGraphEditPart) {
                    ((ConnectionsGraphEditPart)((Object)this.getChildren().get(i))).contributeNodesToGraph(graph, sg, map);
                }
                ++i;
            }
        }
    }

    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map<Object, Object> map) {
        if (!this.isVisible()) {
            return;
        }
        int i = 0;
        while (i < this.getSourceConnections().size()) {
            if (this.getSourceConnections().get(i) instanceof ConnectionsEdgeEditPart) {
                ((ConnectionsEdgeEditPart)((Object)this.getSourceConnections().get(i))).contributeToGraph(graph, map);
            }
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i) instanceof ConnectionsGraphEditPart) {
                ((ConnectionsGraphEditPart)((Object)this.getChildren().get(i))).contributeEdgesToGraph(graph, map);
            }
            ++i;
        }
    }

    public void applyGraphResults(CompoundDirectedGraph graph, Map<Object, Object> map) {
        this.applyOwnGraphResults(graph, map);
        this.applyChildGraphResults(graph, map);
    }

    protected void applyOwnGraphResults(CompoundDirectedGraph graph, Map<Object, Object> map) {
        Node n = (Node)map.get((Object)this);
        if (n == null) {
            this.getFigure().setBounds(zeroRectangle);
            return;
        }
        this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, n.height));
    }

    protected void applyChildGraphResults(CompoundDirectedGraph graph, Map<Object, Object> map) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof ConnectionsGraphEditPart)) continue;
            ((ConnectionsGraphEditPart)((Object)child)).applyGraphResults(graph, map);
        }
        for (Object conn : this.getSourceConnections()) {
            if (!(conn instanceof ConnectionsEdgeEditPart)) continue;
            ((ConnectionsEdgeEditPart)((Object)conn)).applyGraphResults(graph, map);
        }
    }

    public RootEditPart getRoot() {
        if (this.getParent() == null) {
            return null;
        }
        return super.getRoot();
    }

    public EditPartViewer getViewer() {
        if (this.getRoot() == null) {
            return null;
        }
        return super.getViewer();
    }

    public void deepRefresh() {
        super.refresh();
        for (Object child : this.getChildren()) {
            if (!(child instanceof ConnectionsGraphEditPart)) continue;
            ((ConnectionsGraphEditPart)((Object)child)).deepRefresh();
        }
    }

    public void refresh() {
        if (this.getRoot() != null && !this.getRoot().getChildren().isEmpty() && this.getRoot().getChildren().get(0) instanceof ConnectionsDiagramRootEditPart && ((ConnectionsDiagramRootEditPart)((Object)this.getRoot().getChildren().get(0))).isStale()) {
            return;
        }
        super.refresh();
    }

    public boolean hasVisibleChildren() {
        boolean visibleChildren = false;
        for (Object o : this.getChildren()) {
            ConnectionsGraphEditPart graphEditPart;
            if (o instanceof NestedResourceGraphNodeEditPart) {
                if (!((NestedResourceGraphNodeEditPart)((Object)o)).hasVisibleChildren()) continue;
                visibleChildren = true;
                break;
            }
            if (!(o instanceof ConnectionsGraphEditPart) || !(graphEditPart = (ConnectionsGraphEditPart)((Object)o)).isVisible()) continue;
            visibleChildren = true;
            break;
        }
        return visibleChildren;
    }

    protected int getGraphDirection() {
        if (this.getRoot().getContents() instanceof ConnectionsDiagramRootEditPart) {
            return ((ConnectionsDiagramRootEditPart)this.getRoot().getContents()).getGraphDirection();
        }
        return 4;
    }

    public boolean isVisible() {
        return this.getFigure().isVisible();
    }

    public boolean setVisibility(boolean visible) {
        boolean hasChanged = visible ^ this.getFigure().isVisible();
        if (hasChanged) {
            this.getFigure().setVisible(visible);
        }
        return hasChanged;
    }

    protected void setRootStale(boolean stale) {
        if (this.getRoot() != null && !this.getRoot().getChildren().isEmpty() && this.getRoot().getChildren().get(0) instanceof ConnectionsDiagramRootEditPart) {
            ((ConnectionsDiagramRootEditPart)((Object)this.getRoot().getChildren().get(0))).setStale(stale);
        }
    }

    public void filterOut(String text) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof ConnectionsGraphEditPart)) continue;
            ((ConnectionsGraphEditPart)((Object)child)).filterOut(text);
        }
    }
}

