/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.editparts;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.NodeConnection;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsDiagramRootEditPart;
import com.ibm.cics.ia.ui.viz.editparts.ConnectionsGraphEditPart;
import com.ibm.cics.ia.ui.viz.editparts.Messages;
import com.ibm.cics.ia.ui.viz.editparts.ResourceNodeGraphEditPart;
import com.ibm.cics.ia.ui.viz.figures.CommandConnectionFigure;
import com.ibm.cics.ia.ui.viz.figures.ResourceConnectionFigure;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class ConnectionsEdgeEditPart
extends AbstractConnectionEditPart
implements IModelChangeListener<NodeConnection> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AccessibleEditPart accessibleEditPart;
    private String accessibleName;

    public ConnectionsEdgeEditPart(NodeConnection model) {
        this.setModel(model);
        model.addModelChangeListener((IModelChangeListener)this);
        this.accessibleName = this.getAccessibleName(model);
    }

    public void setFigureSelected(boolean selected) {
        IFigure figure = this.getFigure();
        if (figure instanceof ResourceConnectionFigure) {
            ((ResourceConnectionFigure)this.getFigure()).setSelected(selected);
        }
        if (figure instanceof CommandConnectionFigure) {
            ((CommandConnectionFigure)this.getFigure()).setSelected(selected);
        }
    }

    protected IFigure createFigure() {
        NodeConnection model = (NodeConnection)this.getModel();
        ResourceConnectionFigure conn = new ResourceConnectionFigure((NodeConnection)this.getModel());
        return conn;
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy policy = new NonResizableEditPolicy(){

            protected void showSelection() {
                ConnectionsEdgeEditPart.this.setFigureSelected(true);
                if (ConnectionsEdgeEditPart.this.getSource() != null && ConnectionsEdgeEditPart.this.getTarget() != null) {
                    ((ResourceNodeGraphEditPart)ConnectionsEdgeEditPart.this.getSource()).setFigureSelected(true);
                    ((ResourceNodeGraphEditPart)ConnectionsEdgeEditPart.this.getTarget()).setFigureSelected(true);
                }
            }

            protected void hideSelection() {
                ConnectionsEdgeEditPart.this.setFigureSelected(false);
                if (ConnectionsEdgeEditPart.this.getSource() != null && ConnectionsEdgeEditPart.this.getTarget() != null) {
                    ((ResourceNodeGraphEditPart)ConnectionsEdgeEditPart.this.getSource()).setFigureSelected(false);
                    ((ResourceNodeGraphEditPart)ConnectionsEdgeEditPart.this.getTarget()).setFigureSelected(false);
                }
            }
        };
        policy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        policy.activate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEditPart == null) {
            this.accessibleEditPart = this.createAccessible();
        }
        return this.accessibleEditPart;
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

            public void getName(AccessibleEvent e) {
                e.result = ConnectionsEdgeEditPart.this.accessibleName;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }

    public void contributeToGraph(CompoundDirectedGraph graph, Map<Object, Object> map) {
        if (this.getSource() == null || this.getTarget() == null || !this.getSource().isActive() || !this.getTarget().isActive()) {
            return;
        }
        if (this.getSource() instanceof ConnectionsGraphEditPart && !((ConnectionsGraphEditPart)this.getSource()).isVisible()) {
            return;
        }
        if (this.getTarget() instanceof ConnectionsGraphEditPart && !((ConnectionsGraphEditPart)this.getTarget()).isVisible()) {
            return;
        }
        Node source = (Node)map.get(this.getSource());
        Node target = (Node)map.get(this.getTarget());
        if (source == null || target == null) {
            return;
        }
        Edge e = new Edge((Object)this, source, target);
        e.weight = 2;
        graph.edges.add((Object)e);
        map.put((Object)this, e);
    }

    protected void applyGraphResults(CompoundDirectedGraph graph, Map<Object, Object> map) {
        PolylineConnection conn = (PolylineConnection)this.getConnectionFigure();
        Edge e = (Edge)map.get((Object)this);
        if (e == null) {
            conn.setVisible(false);
            return;
        }
        conn.setVisible(true);
        NodeList nodes = e.vNodes;
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                this.addBendPoint(bends, vn, e.isFeedback());
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }

    private void addBendPoint(List<AbsoluteBendpoint> bends, Node vn, boolean isFeedback) {
        int x = vn.x;
        int y = vn.y;
        if (this.getRoot().getContents() instanceof ConnectionsDiagramRootEditPart && ((ConnectionsDiagramRootEditPart)this.getRoot().getContents()).getGraphDirection() == 16) {
            if (isFeedback) {
                bends.add(new AbsoluteBendpoint(x + vn.width, y));
                bends.add(new AbsoluteBendpoint(x, y));
            } else {
                bends.add(new AbsoluteBendpoint(x, y));
                bends.add(new AbsoluteBendpoint(x + vn.width, y));
            }
        } else if (isFeedback) {
            bends.add(new AbsoluteBendpoint(x, y + vn.height));
            bends.add(new AbsoluteBendpoint(x, y));
        } else {
            bends.add(new AbsoluteBendpoint(x, y));
            bends.add(new AbsoluteBendpoint(x, y + vn.height));
        }
    }

    public String getAccessibleName(Object model) {
        NodeConnection resourceNodeConnection = (NodeConnection)model;
        StringBuilder verbNames = new StringBuilder();
        ArrayList verbs = resourceNodeConnection.getVerbs();
        String sourceName = IAUtilities.EMPTY_STRING;
        String targetName = IAUtilities.EMPTY_STRING;
        sourceName = String.valueOf(ResourceTypeRenderer.asText(((Resource)resourceNodeConnection.getSource().getObject()).getTypeName())) + " " + ResourceRenderer.asText((Resource)resourceNodeConnection.getSource().getObject()) + " ";
        targetName = " " + ResourceTypeRenderer.asText(((Resource)resourceNodeConnection.getTarget().getObject()).getTypeName()) + " " + ResourceRenderer.asText((Resource)resourceNodeConnection.getTarget().getObject()) + " ";
        for (String verb : verbs) {
            if (!IAUtilities.hasContent((String)verb)) continue;
            verbNames.append(String.valueOf(verb) + ", ");
        }
        if (verbNames.length() >= 2) {
            verbNames.setLength(verbNames.length() - 2);
        }
        if (verbNames.length() > 0) {
            return String.valueOf(sourceName) + verbNames.toString() + targetName;
        }
        return MessageFormat.format(Messages.getString("ResourceConnectionsGraphEditPart.Accessible.BelongsToResource"), targetName, sourceName);
    }

    public void onModelChanged(NodeConnection model) {
        this.setFigureSelected(model.isSelected());
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isVisible() {
        return this.getFigure().isVisible();
    }
}

