/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.anchors;

import com.ibm.cics.ia.ui.viz.anchors.BottomAnchor;
import com.ibm.cics.ia.ui.viz.anchors.LeftAnchor;
import com.ibm.cics.ia.ui.viz.anchors.RightAnchor;
import com.ibm.cics.ia.ui.viz.anchors.TopAnchor;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;

public class GraphInOutAnchor
extends AbstractConnectionAnchor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int orientation;
    private TopAnchor top;
    private LeftAnchor left;
    private BottomAnchor bottom;
    private RightAnchor right;
    private boolean incoming;

    public GraphInOutAnchor(IFigure source, int offset, boolean isIncoming) {
        super(source);
        this.top = new TopAnchor(source, offset);
        this.bottom = new BottomAnchor(source, offset);
        this.right = new RightAnchor(source, offset);
        this.left = new LeftAnchor(source, offset);
        this.incoming = isIncoming;
        this.orientation = 16;
    }

    public Point getLocation(Point reference) {
        if (this.orientation == 16) {
            if (this.incoming) {
                return this.left.getLocation(reference);
            }
            return this.right.getLocation(reference);
        }
        if (this.incoming) {
            return this.top.getLocation(reference);
        }
        return this.bottom.getLocation(reference);
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }
}

