/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.anchors;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class BottomAnchor
extends AbstractConnectionAnchor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int offset;

    public BottomAnchor(IFigure source, int offset) {
        super(source);
        this.offset = offset;
    }

    public Point getLocation(Point reference) {
        Rectangle r = this.getOwner().getBounds().getCopy();
        this.getOwner().translateToAbsolute((Translatable)r);
        int off = this.offset;
        if (off == -1) {
            off = r.width / 2;
        }
        if (r.contains(reference) || r.bottom() > reference.y) {
            return r.getTopLeft().translate(off, 0);
        }
        return r.getBottomLeft().translate(off, -1);
    }
}

