/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz;

import com.ibm.cics.ia.model.DB2Resource;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.IMSResource;
import com.ibm.cics.ia.model.MQResource;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;

public class TypeColorFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Color DB2_COLOR_HI = new Color(null, 240, 200, 0);
    private static Color DB2_COLOR_LO = new Color(null, 240, 200, 75);
    private static Color IMS_COLOR_HI = new Color(null, 0, 200, 200);
    private static Color IMS_COLOR_LO = new Color(null, 75, 200, 200);
    private static Color MQ_COLOR_HI = new Color(null, 200, 0, 200);
    private static Color MQ_COLOR_LO = new Color(null, 200, 75, 200);
    private static Color APPLICATION_COLOR_HI = new Color(null, 71, 91, 130);
    private static Color APPLICATION_COLOR_LO = new Color(null, 113, 119, 130);
    private static Color TRANSACTION_COLOR_HI = new Color(null, 22, 123, 24);
    private static Color TRANSACTION_COLOR_LO = new Color(null, 81, 123, 82);
    private static Color PROGRAM_COLOR_HI = new Color(null, 71, 91, 130);
    private static Color PROGRAM_COLOR_LO = new Color(null, 113, 119, 130);
    private static Color REGION_COLOR_HI = new Color(null, 113, 60, 23);
    private static Color REGION_COLOR_LO = new Color(null, 113, 82, 61);
    private static Color CICS_COLOR_LO = ColorConstants.gray;
    private static Color CICS_COLOR_HI = ColorConstants.darkGray;

    public static Color getColor(Resource resource, boolean highSaturation) {
        if (resource instanceof Region) {
            return highSaturation ? REGION_COLOR_HI : REGION_COLOR_LO;
        }
        if (resource instanceof TSApplication || resource instanceof IAApplication) {
            return highSaturation ? APPLICATION_COLOR_HI : APPLICATION_COLOR_LO;
        }
        if (resource instanceof Transaction) {
            return highSaturation ? TRANSACTION_COLOR_HI : TRANSACTION_COLOR_LO;
        }
        if (resource instanceof Program) {
            return highSaturation ? PROGRAM_COLOR_HI : PROGRAM_COLOR_LO;
        }
        if (resource instanceof DB2Resource) {
            return highSaturation ? DB2_COLOR_HI : DB2_COLOR_LO;
        }
        if (resource instanceof IMSResource) {
            return highSaturation ? IMS_COLOR_HI : IMS_COLOR_LO;
        }
        if (resource instanceof MQResource) {
            return highSaturation ? MQ_COLOR_HI : MQ_COLOR_LO;
        }
        return highSaturation ? CICS_COLOR_HI : CICS_COLOR_LO;
    }
}

