/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.FindResourcesForApplicationCommand;
import com.ibm.cics.ia.commands.FindResourcesForTSApplicationCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowApplicationResourcesHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowApplicationResourcesHandler.class.getPackage().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)ShowApplicationResourcesHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        FindResourcesForApplicationCommand.SourceTable callType = this.getCallType();
        Platform platform = null;
        TSApplication application = null;
        Operation operation = null;
        String objectName = null;
        FindResourcesForTSApplicationCommand showResourcesCommand = null;
        if (object instanceof Operation) {
            operation = (Operation)object;
            application = operation.getApplication();
            platform = application.getPlatform();
            showResourcesCommand = new FindResourcesForTSApplicationCommand();
            objectName = String.valueOf(ResourceTypeRenderer.asText("OPERATION")) + " (" + operation.getName() + ")";
        } else if (object instanceof TSApplication) {
            application = (TSApplication)object;
            platform = application.getPlatform();
            showResourcesCommand = new FindResourcesForTSApplicationCommand();
            objectName = String.valueOf(ResourceTypeRenderer.asText("TS_APPLICATION")) + " (" + application.getName() + ")";
        } else if (object instanceof Platform) {
            platform = (Platform)object;
            showResourcesCommand = new FindResourcesForTSApplicationCommand();
            objectName = String.valueOf(ResourceTypeRenderer.asText("PLATFORM")) + " (" + platform.getName() + ")";
        }
        if (showResourcesCommand != null) {
            ((FindResourcesForTSApplicationCommand)showResourcesCommand).setPlatform(platform != null ? platform.getName() : null);
            showResourcesCommand.setApplication(application != null ? application.getName() : null);
            showResourcesCommand.setMajorVersion(application != null ? application.getMajorVersion() : 0);
            showResourcesCommand.setMinorVersion(application != null ? application.getMinorVersion() : 0);
            showResourcesCommand.setMicroVersion(application != null ? application.getMicroVersion() : 0);
            showResourcesCommand.setOperationName(operation != null ? operation.getName() : null);
            String descriptionPrefix = Messages.getString("ShowApplicationResourcesAction." + callType.toString());
            String description = MessageFormat.format(Messages.getString("ShowApplicationResourcesAction.description"), descriptionPrefix, objectName);
            showResourcesCommand.setType(callType);
            DisplayableData displayableData = (DisplayableData)showResourcesCommand.getAdapter(DisplayableData.class);
            displayableData.setImage(ImageFactory.getApplicationImage());
            displayableData.setDescription(description);
            Activator.executeSearch((Command)showResourcesCommand);
        }
        Debug.exit((Logger)logger, (String)ShowApplicationResourcesHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }

    public FindResourcesForApplicationCommand.SourceTable getCallType() {
        return FindResourcesForApplicationCommand.SourceTable.ALL;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

