/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.ZOSUIUtilities;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;

public class OpenZOSDataEntryHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(OpenZOSDataEntryHandler.class.getPackage().getName());
    private static final String DSNAME = "dsname";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)OpenZOSDataEntryHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String dsname = event.getParameter(DSNAME);
        if (IAUtilities.hasContent((String)dsname) && ZOSActivator.getZOSConnectable().canPerform("ACTION_SUPPORT_JOBS", "")) {
            ZOSUIUtilities.openDataSet((String)dsname);
        }
        Debug.exit((Logger)logger, (String)OpenZOSDataEntryHandler.class.getName(), (String)"execute");
        return dsname;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

