/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.IAOperationsView;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;

public class IAOperationsHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(IAOperationsHandler.class.getPackage().getName());
    public static final String TYPE = "type";
    public static final String TYPE_EXPAND_USERS = "expand_users";
    public static final String TYPE_EXPAND_REGIONS = "expand_regions";
    public static final String TYPE_EXPAND_CONNECTION = "expand_connection";
    public static final String CONFIGURATION_ID = "configurationid";

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)IAOperationsHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String type = event.getParameter(TYPE);
        String configurationId = event.getParameter(CONFIGURATION_ID);
        IAOperationsView iaOperationsView = Activator.findIAOperationsView();
        if (iaOperationsView != null) {
            if (TYPE_EXPAND_CONNECTION.equals(type)) {
                iaOperationsView.expandConnectionNode(configurationId);
                Debug.exit((Logger)logger, (String)IAOperationsHandler.class.getName(), (String)"execute");
                return configurationId;
            }
            if (TYPE_EXPAND_REGIONS.equals(type)) {
                iaOperationsView.expandRegionsNode(configurationId);
                Debug.exit((Logger)logger, (String)IAOperationsHandler.class.getName(), (String)"execute");
                return configurationId;
            }
            if (TYPE_EXPAND_USERS.equals(type)) {
                iaOperationsView.expandUsersNode(configurationId);
                Debug.exit((Logger)logger, (String)IAOperationsHandler.class.getName(), (String)"execute");
                return configurationId;
            }
        }
        Debug.exit((Logger)logger, (String)IAOperationsHandler.class.getName(), (String)"execute");
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

