/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.model.Operation;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPAP1;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.CloudExplorer;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.NavigatorView;
import com.ibm.cics.ia.ui.TypeValueDialog;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteByApplicationHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DeleteByApplicationHandler.class.getPackage().getName());
    private Operation operation = null;
    private TSApplication application = null;
    private Platform platform = null;

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String taskName;
        int applVer3;
        int applVer2;
        int applVer1;
        String applicationName;
        String platformName;
        String operationName;
        Debug.enter((Logger)logger, (String)DeleteByApplicationHandler.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
        if (object instanceof Operation) {
            this.operation = (Operation)object;
            this.application = this.operation.getApplication();
            this.platform = this.application.getPlatform();
            operationName = this.operation.getName();
            platformName = this.platform != null ? this.platform.getName() : null;
            applicationName = this.application.getName();
            applVer1 = this.application.getMajorVersion();
            applVer2 = this.application.getMinorVersion();
            applVer3 = this.application.getMicroVersion();
            taskName = MessageFormat.format(Messages.getString("DeleteData"), operationName);
        } else if (object instanceof TSApplication) {
            this.application = (TSApplication)object;
            this.platform = this.application.getPlatform();
            taskName = MessageFormat.format(Messages.getString("DeleteData"), this.application.getFullName());
            platformName = this.platform != null ? this.platform.getName() : null;
            applicationName = this.application.getName();
            operationName = null;
            applVer1 = this.application.getMajorVersion();
            applVer2 = this.application.getMinorVersion();
            applVer3 = this.application.getMicroVersion();
        } else {
            this.platform = (Platform)object;
            taskName = MessageFormat.format(Messages.getString("DeleteData"), this.platform.getName());
            platformName = this.platform.getName();
            applicationName = null;
            operationName = null;
            applVer1 = 0;
            applVer2 = 0;
            applVer3 = 0;
        }
        messageBox.setText(taskName);
        messageBox.setMessage(taskName);
        int result = messageBox.open();
        if (result == 64) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        Debug.enter((Logger)logger, (String)"DeleteByApplicationHandler.run().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        monitor.beginTask(taskName, -1);
                        StoredProcedureCommand command = new StoredProcedureCommand(){
                            private SelectionObject selectionObject;

                            public Object processRow(ResultSet resultSet) throws SQLException {
                                return null;
                            }

                            public SelectionObject getSelectionObject() {
                                return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPAP1().getSelectionObject("DEL", platformName, applicationName, applVer1, applVer2, applVer3, operationName)) : this.selectionObject;
                            }
                        };
                        command.setCategory("com.ibm.cics.ia.connection.db2");
                        command.setAsync(false);
                        command.start();
                        DeleteByApplicationHandler.this.updateUI(DeleteByApplicationHandler.this.application, DeleteByApplicationHandler.this.operation, ((StoredProcedure)command.getSelectionObject()).getOutputValues());
                        monitor.done();
                        Debug.enter((Logger)logger, (String)"DeleteByApplicationHandler.run().ProgressMonitorDialog", (String)"run");
                    }
                });
            }
            catch (InvocationTargetException e) {
                IAPlugin.getDefault().logError("Unable to delete data", (Throwable)e);
            }
            catch (InterruptedException e) {
                IAPlugin.getDefault().logError("Unable to delete data", (Throwable)e);
            }
        }
        Debug.exit((Logger)logger, (String)DeleteByApplicationHandler.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }

    private void updateUI(final TSApplication application, final Operation operation, final Map<String, Object> nameToValue) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String title;
                if (operation != null) {
                    title = MessageFormat.format(Messages.getString("DeleteData.completed.title"), operation.getName());
                    application.removeOperation(operation);
                } else if (application != null) {
                    title = MessageFormat.format(Messages.getString("DeleteData.completed.title"), application.getFullName());
                    if (application.getPlatform() != null) {
                        application.getPlatform().getTsApplications().remove(application);
                    }
                } else {
                    title = MessageFormat.format(Messages.getString("DeleteData.completed.title"), DeleteByApplicationHandler.this.platform.getName());
                }
                String messagePrefix = "DeleteData.completed.msg";
                String message = Messages.getString(messagePrefix);
                TypeValueDialog dlg = new TypeValueDialog(Display.getCurrent().getActiveShell(), nameToValue, title, message, String.valueOf(messagePrefix) + ".");
                dlg.open();
                NavigatorView navigatorView = Activator.findNavigatorView();
                if (navigatorView != null) {
                    CloudExplorer cloudExplorer = navigatorView.getCloudExplorer();
                    cloudExplorer.runSearch();
                }
            }
        });
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

