/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.composites.GenericPropertyItem;
import com.ibm.cics.ia.ui.composites.PropertyValidator;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class UpcaseTextPropertyItem
extends GenericPropertyItem
implements KeyListener,
FocusListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text text;
    private TreeEditor editor;
    private PropertyValidator validator;
    private boolean error = false;

    public UpcaseTextPropertyItem(TreeItem parent, CollectorOptionsEditor atomEditor, String key, String description) {
        super(parent, atomEditor, key, description);
        this.text = new Text((Composite)parent.getParent(), 0);
        this.text.addKeyListener((KeyListener)this);
        this.text.addFocusListener((FocusListener)this);
        this.editor = new TreeEditor(parent.getParent());
        this.editor.grabHorizontal = true;
        this.editor.setEditor((Control)this.text, this.treeItem, 1);
        this.validator = new PropertyValidator(key);
    }

    @Override
    public void setValue(String value, boolean dirty) {
        this.value = value;
        this.text.setText(value);
        if (!dirty) {
            this.oldValue = value;
            this.treeItem.setFont(NORMAL_FONT);
            this.text.setFont(NORMAL_FONT);
        } else {
            this.treeItem.setFont(BOLD_FONT);
            this.text.setFont(BOLD_FONT);
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void keyPressed(KeyEvent e) {
        Character ch = Character.valueOf(e.character);
        if (ch.charValue() >= ' ' && ch.charValue() != '\u007f') {
            Point point = this.text.getSelection();
            String str = this.text.getText();
            String upcase = (String.valueOf(str.substring(0, point.x)) + ch + str.substring(point.x, str.length())).toUpperCase();
            this.text.setText(upcase);
            ++point.x;
            ++point.y;
            this.text.setSelection(point);
            e.doit = false;
        }
    }

    public void keyReleased(KeyEvent e) {
        String value = this.text.getText();
        this.treeItem.setFont(BOLD_FONT);
        this.text.setFont(BOLD_FONT);
        if (!this.validator.validateInput(value)) {
            this.text.setForeground(Display.getCurrent().getSystemColor(3));
            this.text.setToolTipText(this.validator.getErrorMessage());
            this.atomEditor.addError((Control)this.text, this.validator.getErrorMessage());
            this.error = true;
        } else {
            if (this.error) {
                this.text.setForeground(Display.getCurrent().getSystemColor(2));
                this.text.setToolTipText("");
                this.atomEditor.removeError((Control)this.text);
                this.error = false;
            }
            this.value = value;
            if (!value.equals(this.oldValue)) {
                this.treeItem.setFont(BOLD_FONT);
                this.text.setFont(BOLD_FONT);
                this.atomEditor.fireDirty();
            } else {
                this.treeItem.setFont(NORMAL_FONT);
                this.text.setFont(NORMAL_FONT);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.error) {
            this.text.setText(this.value);
            this.text.setForeground(Display.getCurrent().getSystemColor(2));
            this.text.setToolTipText("");
            this.error = false;
            this.atomEditor.removeError((Control)this.text);
        }
    }
}

