/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QueryTimeComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Calendar calendar;
    private Button beforeButton;
    private Button afterButton;
    private DateTime calendarComposite;
    private DateTime dateComposite;
    private DateTime timeComposite;
    private ToolItem selectedOperatorToolItem = null;
    public static final String BEFORE = Messages.getString("QueryTimeComposite.label.before");
    public static final String AFTER = Messages.getString("QueryTimeComposite.label.after");
    protected List<Operator> operators = Arrays.asList(Operator.values());

    private void selectOperatorToolItem(Operator oper) {
        this.selectedOperatorToolItem.setText(oper.getTimeDisplayName());
        this.selectedOperatorToolItem.setImage(ImageFactory.getImageForOperator(oper));
        this.selectedOperatorToolItem.setToolTipText(oper.getTimeDisplayName());
        this.notifyListeners();
    }

    @Override
    public Composite createComposite(Composite parent) {
        ToolItem operatorSelectionToolItem;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        final ToolBar toolBar = new ToolBar(composite, 0x820000);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.selectedOperatorToolItem = operatorSelectionToolItem = new ToolItem(toolBar, 0x800004);
        final Menu operatorMenu = new Menu((Decorations)parent.getShell(), 8);
        operatorSelectionToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = operatorSelectionToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                operatorMenu.setLocation(pt.x, pt.y);
                operatorMenu.setVisible(true);
            }
        });
        SelectionAdapter menuListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                Operator operator = (Operator)((Object)selectedMenuItem.getData());
                QueryTimeComposite.this.selectOperatorToolItem(operator);
                Comparator comparator = Comparator.EQ;
                boolean isNot = false;
                if (operator.getComparison().equals("<>")) {
                    isNot = true;
                } else if (operator.getComparison().equals("<")) {
                    comparator = Comparator.LT;
                } else if (operator.getComparison().equals("<=")) {
                    comparator = Comparator.LE;
                } else if (operator.getComparison().equals(">")) {
                    comparator = Comparator.GT;
                } else if (operator.getComparison().equals(">=")) {
                    comparator = Comparator.GE;
                }
                Clause clause = (Clause)QueryTimeComposite.this.constraint;
                long millis = QueryTimeComposite.this.calendar.getTimeInMillis();
                Timestamp timestamp = new Timestamp(millis);
                Object[] newValues = new Object[]{timestamp};
                Clause newClause = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), comparator, newValues, isNot);
                QueryTimeComposite.this.constraint = newClause;
                QueryTimeComposite.this.refresh();
            }
        };
        String longestName = "";
        for (Operator oper : this.operators) {
            MenuItem menuItem = new MenuItem(operatorMenu, 8);
            String operatorName = oper.getTimeDisplayName();
            if (longestName.length() < operatorName.length()) {
                longestName = operatorName;
            }
            menuItem.setText(operatorName);
            menuItem.setData((Object)oper);
            menuItem.setImage(ImageFactory.getImageForOperator(oper));
            menuItem.addSelectionListener((SelectionListener)menuListener);
        }
        operatorSelectionToolItem.setText(longestName);
        operatorSelectionToolItem.setImage(ImageFactory.getImageForOperator(Operator.EQ));
        toolBar.layout();
        int x = toolBar.computeSize((int)-1, (int)-1).x;
        GridData toolBardata = new GridData(4, 4, true, false);
        toolBardata.minimumWidth = x;
        toolBardata.widthHint = x;
        toolBar.setLayoutData((Object)toolBardata);
        ScrolledComposite sc = new ScrolledComposite(composite, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite timeAndDateComposite = new Composite((Composite)sc, 0);
        gridLayout = new GridLayout(1, false);
        timeAndDateComposite.setLayout((Layout)gridLayout);
        this.calendarComposite = new DateTime(timeAndDateComposite, 3072);
        this.calendarComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryTimeComposite.this.calendar.set(1, QueryTimeComposite.this.calendarComposite.getYear());
                QueryTimeComposite.this.calendar.set(2, QueryTimeComposite.this.calendarComposite.getMonth());
                QueryTimeComposite.this.calendar.set(5, QueryTimeComposite.this.calendarComposite.getDay());
                Clause clause = (Clause)QueryTimeComposite.this.constraint;
                long millis = QueryTimeComposite.this.calendar.getTimeInMillis();
                Timestamp timestamp = new Timestamp(millis);
                Object[] newValues = new Object[]{timestamp};
                Clause newClause = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), clause.getComparator(), newValues, clause.isNot());
                QueryTimeComposite.this.constraint = newClause;
                QueryTimeComposite.this.refresh();
            }
        });
        Composite dateTimeComposite = new Composite(timeAndDateComposite, 0);
        gridLayout = new GridLayout(2, false);
        dateTimeComposite.setLayout((Layout)gridLayout);
        GridData dateTimeData = new GridData(4, 4, true, true);
        dateTimeComposite.setLayoutData((Object)dateTimeData);
        this.dateComposite = new DateTime(dateTimeComposite, 2080);
        this.dateComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryTimeComposite.this.calendar.set(1, QueryTimeComposite.this.dateComposite.getYear());
                QueryTimeComposite.this.calendar.set(2, QueryTimeComposite.this.dateComposite.getMonth());
                QueryTimeComposite.this.calendar.set(5, QueryTimeComposite.this.dateComposite.getDay());
                Clause clause = (Clause)QueryTimeComposite.this.constraint;
                long millis = QueryTimeComposite.this.calendar.getTimeInMillis();
                Timestamp timestamp = new Timestamp(millis);
                Object[] newValues = new Object[]{timestamp};
                Clause newClause = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), clause.getComparator(), newValues, clause.isNot());
                QueryTimeComposite.this.constraint = newClause;
                QueryTimeComposite.this.refresh();
            }
        });
        this.timeComposite = new DateTime(dateTimeComposite, 2176);
        this.timeComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryTimeComposite.this.calendar.set(11, QueryTimeComposite.this.timeComposite.getHours());
                QueryTimeComposite.this.calendar.set(12, QueryTimeComposite.this.timeComposite.getMinutes());
                QueryTimeComposite.this.calendar.set(13, QueryTimeComposite.this.timeComposite.getSeconds());
                Clause clause = (Clause)QueryTimeComposite.this.constraint;
                long millis = QueryTimeComposite.this.calendar.getTimeInMillis();
                Timestamp timestamp = new Timestamp(millis);
                Object[] newValues = new Object[]{timestamp};
                Clause newClause = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), clause.getComparator(), newValues, clause.isNot());
                QueryTimeComposite.this.constraint = newClause;
                QueryTimeComposite.this.refresh();
            }
        });
        sc.setContent((Control)timeAndDateComposite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(timeAndDateComposite.computeSize(-1, -1));
        sc.setShowFocusedControl(true);
        return composite;
    }

    protected void refresh() {
        this.calendarComposite.setDate(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
        this.timeComposite.setTime(this.calendar.get(11), this.calendar.get(12), this.calendar.get(13));
        this.dateComposite.setDate(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
        this.notifyListeners();
    }

    private String formatIntAsDoubleCharacter(int input) {
        StringBuffer result = new StringBuffer(Integer.toString(input));
        if (input < 10) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    @Override
    public void initialize() {
        Values values;
        List valuesList;
        Clause clause = (Clause)this.constraint;
        Operator oper = Operator.EQ;
        if (clause.getComparator() == null) {
            Clause newClause;
            valuesList = clause.getValues();
            values = (Values)valuesList.get(0);
            long millis = this.calendar.getTimeInMillis();
            Timestamp timestamp = new Timestamp(millis);
            Object[] newValues = new Object[]{timestamp};
            clause = newClause = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), Comparator.EQ, newValues, clause.isNot());
        } else if (clause.getComparator().equals((Object)Comparator.EQ) && clause.isNot()) {
            oper = Operator.NE;
        } else if (clause.getComparator().equals((Object)Comparator.LT)) {
            oper = Operator.LT;
        } else if (clause.getComparator().equals((Object)Comparator.LE)) {
            oper = Operator.LE;
        } else if (clause.getComparator().equals((Object)Comparator.GT)) {
            oper = Operator.GT;
        } else if (clause.getComparator().equals((Object)Comparator.GE)) {
            oper = Operator.GE;
        }
        this.selectOperatorToolItem(oper);
        valuesList = clause.getValues();
        values = (Values)valuesList.get(0);
        Object obj = values.getValue();
        String str = obj.toString();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date();
        try {
            date = dateFormat.parse(str);
        }
        catch (ParseException newClause) {
            // empty catch block
        }
        this.calendar = Calendar.getInstance();
        if (date == null) {
            date = this.calendar.getTime();
        } else {
            this.calendar.setTime(date);
        }
        long millis = this.calendar.getTimeInMillis();
        Timestamp timestamp = new Timestamp(millis);
        Object[] newValues = new Object[]{timestamp};
        Clause newClause = PresentationFactory.getInstance().createSimpleCondition((ColumnReference)clause.getColumns().get(0), clause.getComparator(), newValues, clause.isNot());
        this.constraint = newClause;
        this.refresh();
    }

    public static enum Operator {
        EQ,
        NE,
        LT,
        GT,
        GE,
        LE;


        public String getTimeDisplayName() {
            switch (this) {
                case EQ: {
                    return Messages.getString("QueryTimeComposite.label.TimeDisplayNameIs");
                }
                case NE: {
                    return Messages.getString("QueryTimeComposite.label.TimeDisplayNameIsNot");
                }
                case LT: {
                    return Messages.getString("QueryTimeComposite.label.TimeDisplayNameIsBefore");
                }
                case GT: {
                    return Messages.getString("QueryTimeComposite.label.TimeDisplayNameIsAfter");
                }
                case LE: {
                    return Messages.getString("QueryTimeComposite.label.TimeDisplayNameIsAtOrBefore");
                }
                case GE: {
                    return Messages.getString("QueryTimeComposite.label.TimeDisplayNameIsAtOrAfter");
                }
            }
            return null;
        }

        public String getIconImageName() {
            switch (this) {
                case EQ: {
                    return "equal.gif";
                }
                case NE: {
                    return "notequal.gif";
                }
                case LT: {
                    return "lessThan_pal.gif";
                }
                case GT: {
                    return "greaterThan_pal.gif";
                }
                case LE: {
                    return "lessEqual_pal.gif";
                }
                case GE: {
                    return "greaterEqual_pal.gif";
                }
            }
            return null;
        }

        public String getComparison() {
            switch (this) {
                case EQ: {
                    return "=";
                }
                case NE: {
                    return "<>";
                }
                case LT: {
                    return "<";
                }
                case GT: {
                    return ">";
                }
                case LE: {
                    return "<=";
                }
                case GE: {
                    return ">=";
                }
            }
            return null;
        }
    }
}

