/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QueryEditableTableComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String TEXT_CONTROL = "TEXT_CONTROL";
    protected static final String TABLE_ITEM = "TABLE_ITEM";
    protected Table table;
    private ToolItem toolItem;
    private Button columnButton;
    private Button tableButton;
    protected List tableTextItems = new ArrayList();
    private Label columnLabel;
    private String selectedColumn;
    private Menu columnMenu;
    private ToolItem columnToolItem;
    private ToolBar columnToolBar;

    @Override
    public Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 1;
        composite.setLayout((Layout)gridLayout);
        final ToolBar toolBar = new ToolBar(composite, 0x820000);
        GridData data = new GridData(4, 0x1000000, true, false);
        toolBar.setLayoutData((Object)data);
        this.toolItem = new ToolItem(toolBar, 0x800004);
        this.toolItem.setToolTipText(Messages.getString("QueryCheckboxTableComposite.toolItem.toolTipText"));
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        this.toolItem.setImage(ImageFactory.getNotEqualImage());
        int typeWidth = this.toolItem.getBounds().width;
        data = new GridData(4, 0x1000000, true, false);
        data.minimumWidth = typeWidth;
        toolBar.setLayoutData((Object)data);
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        this.toolItem.setImage(ImageFactory.getEqualImage());
        final Menu menu = new Menu((Decorations)composite.getShell(), 8);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = QueryEditableTableComposite.this.toolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        MenuItem isMenuItem = new MenuItem(menu, 8);
        isMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        isMenuItem.setImage(ImageFactory.getEqualImage());
        isMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditableTableComposite.this.setIs(true);
            }
        });
        MenuItem isNotMenuItem = new MenuItem(menu, 8);
        isNotMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        isNotMenuItem.setImage(ImageFactory.getNotEqualImage());
        isNotMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditableTableComposite.this.setIs(false);
            }
        });
        data = new GridData(4, 4, true, true);
        if (this.hasEquivalentColumns()) {
            String column2;
            List equivalentColumns = this.getEquivalentColumns();
            final Composite c = new Composite(composite, 0);
            GridData data2 = new GridData(4, 0x1000000, true, false);
            c.setLayout((Layout)new GridLayout(2, false));
            c.setLayoutData((Object)data2);
            this.columnButton = new Button(c, 16);
            data2 = new GridData(16384, 0x1000000, false, false);
            this.columnButton.setLayoutData((Object)data2);
            if (equivalentColumns.size() == 1) {
                this.selectedColumn = column2 = (String)equivalentColumns.get(0);
                Label columnButtonLabel = new Label(c, 0);
                columnButtonLabel.setText(SQLDefinitions.getColumnDescription((String)column2));
                this.columnButton.setData((Object)column2);
            } else {
                this.selectedColumn = column2 = (String)equivalentColumns.get(0);
                this.columnToolBar = new ToolBar(c, 0x800000);
                data2 = new GridData(16384, 4, true, false);
                this.columnToolBar.setLayoutData((Object)data2);
                this.columnToolItem = new ToolItem(this.columnToolBar, 4);
                this.columnToolItem.setToolTipText(Messages.getString("QueryEditableTableComposite.columnLabel.text"));
                this.columnToolItem.setText(SQLDefinitions.getColumnDescription((String)((String)equivalentColumns.get(0))));
                this.columnMenu = new Menu((Decorations)c.getShell(), 8);
                this.columnToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Rectangle rect = QueryEditableTableComposite.this.columnToolItem.getBounds();
                        Point pt = new Point(rect.x, rect.y + rect.height);
                        pt = c.toDisplay(pt);
                        QueryEditableTableComposite.this.columnMenu.setLocation(pt.x, pt.y);
                        QueryEditableTableComposite.this.columnMenu.setVisible(true);
                    }
                });
                for (String column2 : equivalentColumns) {
                    final MenuItem menuItem = new MenuItem(this.columnMenu, 8);
                    menuItem.setText(SQLDefinitions.getColumnDescription((String)column2));
                    menuItem.setData((Object)column2);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ClauseGroup clauses;
                            Clause clause;
                            QueryEditableTableComposite.this.selectedColumn = (String)menuItem.getData();
                            QueryEditableTableComposite.this.columnToolItem.setText(menuItem.getText());
                            QueryEditableTableComposite.this.columnToolBar.pack();
                            QueryEditableTableComposite.this.columnToolBar.layout();
                            QueryEditableTableComposite.this.columnToolBar.getParent().layout(true);
                            QueryEditableTableComposite.this.columnButton.setSelection(true);
                            QueryEditableTableComposite.this.tableButton.setSelection(false);
                            QueryEditableTableComposite.this.setTableEnablement(false);
                            boolean is = false;
                            is = QueryEditableTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableTableComposite.this.constraint).getClauses().get(0)).isNot();
                            QueryEditableTableComposite.this.recalculateFromSelection(QueryEditableTableComposite.this.selectedColumn, is);
                        }
                    });
                    this.columnMenu.setData(column2, (Object)menuItem);
                }
            }
            this.columnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryEditableTableComposite.this.columnButton.getSelection()) {
                        ClauseGroup clauses;
                        Clause clause;
                        boolean is = false;
                        is = QueryEditableTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableTableComposite.this.constraint).getClauses().get(0)).isNot();
                        QueryEditableTableComposite.this.recalculateFromSelection(QueryEditableTableComposite.this.selectedColumn, is);
                        QueryEditableTableComposite.this.setTableEnablement(false);
                    }
                }
            });
            this.tableButton = new Button(c, 16);
            Label tableButtonLabel = new Label(c, 0);
            tableButtonLabel.setText(Messages.getString("QueryEditableTableComposite.tableButtonLabel.text"));
            this.tableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryEditableTableComposite.this.tableButton.getSelection()) {
                        ClauseGroup clauses;
                        Clause clause;
                        boolean is = false;
                        is = QueryEditableTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableTableComposite.this.constraint).getClauses().get(0)).isNot();
                        QueryEditableTableComposite.this.recalculateFromEditableTable(QueryEditableTableComposite.this.table, is);
                        QueryEditableTableComposite.this.setTableEnablement(true);
                    }
                }
            });
            data.horizontalIndent = 20;
        }
        this.table = new Table(composite, 2052);
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        final TableColumn column = new TableColumn(this.table, 0);
        column.setWidth(this.table.getSize().x);
        this.table.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle area = QueryEditableTableComposite.this.table.getClientArea();
                column.setWidth(area.width);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return composite;
    }

    protected void recalculateFromSelection(String selection, boolean is) {
        ColumnReference column = null;
        if (this.constraint instanceof Clause) {
            column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        } else {
            ClauseGroup clauses = (ClauseGroup)this.constraint;
            Clause clause = (Clause)clauses.getClauses().get(0);
            column = (ColumnReference)clause.getColumns().get(0);
        }
        Clause newClause = null;
        Object[] values = new Object[]{selection};
        column.setType(ColumnReference.DataType.Column);
        column.setDirection(Direction.ASC);
        newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, values, !is);
        this.constraint = newClause;
        this.notifyListeners();
    }

    protected void setTableEnablement(boolean b) {
        this.table.setEnabled(b);
        Iterator iterator = this.tableTextItems.iterator();
        while (iterator.hasNext()) {
            ((Text)iterator.next()).setEnabled(b);
        }
    }

    private void setIs(boolean b) {
        String menuText = b ? Messages.getString("QueryEditableTableComposite.QueryEditableTableComposite.button.is") : Messages.getString("QueryEditableTableComposite.QueryEditableTableComposite.button.isnot");
        this.toolItem.setText(menuText);
        Image image = b ? ImageFactory.getEqualImage() : ImageFactory.getNotEqualImage();
        this.toolItem.setImage(image);
        if (this.table.isEnabled()) {
            this.recalculateFromEditableTable(this.table, b);
        } else {
            this.recalculateFromSelection(this.selectedColumn, b);
        }
    }

    @Override
    public void initialize() {
        this.tableTextItems.clear();
        TableItem[] tableItems = this.table.getItems();
        this.setTableEnablement(true);
        int i = 0;
        while (i < tableItems.length) {
            ((Text)tableItems[i].getData(TEXT_CONTROL)).dispose();
            tableItems[i].dispose();
            ++i;
        }
        if (this.constraint instanceof Clause) {
            this.initialize(this.constraint);
        } else {
            List constraints = ((ClauseGroup)this.constraint).getClauses();
            for (ConstraintElement element : constraints) {
                if (!(element instanceof Clause)) continue;
                this.initialize(element);
            }
        }
        if (this.table.isEnabled()) {
            int numberOfItems;
            int i2 = numberOfItems = this.table.getItemCount();
            while (i2 < 25) {
                this.createTableItem(null);
                ++i2;
            }
        }
    }

    private void initialize(ConstraintElement constraint) {
        Clause clause = (Clause)constraint;
        List valuesList = clause.getValues();
        Values values = (Values)valuesList.get(0);
        Object value = values.getValue();
        ColumnReference column = (ColumnReference)clause.getColumns().get(0);
        if (column.getType().equals((Object)ColumnReference.DataType.Column)) {
            int numberOfItems;
            MenuItem menuItem;
            if (this.columnButton != null && this.tableButton != null) {
                this.columnButton.setSelection(true);
                this.tableButton.setSelection(false);
            }
            this.selectedColumn = (String)value;
            if (this.columnMenu != null && (menuItem = (MenuItem)this.columnMenu.getData(this.selectedColumn)) != null) {
                this.columnToolItem.setText(menuItem.getText());
                this.columnToolBar.pack();
                this.columnToolBar.layout();
                this.columnToolBar.getParent().layout(true);
            }
            int i = numberOfItems = this.table.getItemCount();
            while (i < 25) {
                this.createTableItem(null);
                ++i;
            }
            this.setTableEnablement(false);
        } else {
            if (this.columnButton != null && this.tableButton != null) {
                this.columnButton.setSelection(false);
                this.tableButton.setSelection(true);
            }
            if (value instanceof String) {
                String programName = (String)value;
                this.createTableItem(programName);
            } else if (value instanceof String[]) {
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    this.createTableItem((String)iter.next());
                }
            }
            this.setTableEnablement(true);
        }
        this.setIs(!clause.isNot());
    }

    protected void createTableItem(String name) {
        final TableItem newItem = new TableItem(this.table, 0);
        if (name != null) {
            name = name.replace("%", "*");
            newItem.setText(name);
            newItem.setData((Object)name);
        }
        TableEditor tableEditor = new TableEditor(this.table);
        tableEditor.grabHorizontal = true;
        final Text itemText = new Text((Composite)this.table, 0);
        EnsureUppercaseListener.attach((Text)itemText);
        itemText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
            }
        });
        itemText.setData(TABLE_ITEM, (Object)newItem);
        if (name != null) {
            itemText.setText(name);
            itemText.setData((Object)name);
        }
        newItem.setData(TEXT_CONTROL, (Object)itemText);
        tableEditor.setEditor((Control)itemText, newItem, 0);
        itemText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClauseGroup clauses;
                Clause clause;
                newItem.setData((Object)itemText.getText());
                boolean is = false;
                is = QueryEditableTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableTableComposite.this.constraint).getClauses().get(0)).isNot();
                QueryEditableTableComposite.this.recalculateFromEditableTable(QueryEditableTableComposite.this.table, is);
            }
        });
        this.tableTextItems.add(itemText);
    }
}

