/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QueryEditableHexTableComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TEXT_CONTROL = "TEXT_CONTROL";
    private static final String TABLE_ITEM = "TABLE_ITEM";
    private Table programTable;
    private ToolItem toolItem;
    private Button columnButton;
    private Button tableButton;
    private List tableTextItems = new ArrayList();
    private Label columnLabel;
    private String selectedColumn;
    private Menu columnMenu;
    private ToolItem columnToolItem;
    private ToolBar columnToolBar;

    @Override
    public Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 1;
        composite.setLayout((Layout)gridLayout);
        final ToolBar toolBar = new ToolBar(composite, 0x820000);
        GridData data = new GridData(4, 0x1000000, true, false);
        toolBar.setLayoutData((Object)data);
        this.toolItem = new ToolItem(toolBar, 0x800004);
        this.toolItem.setToolTipText(Messages.getString("QueryCheckboxTableComposite.toolItem.toolTipText"));
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        this.toolItem.setImage(ImageFactory.getNotEqualImage());
        int typeWidth = this.toolItem.getBounds().width;
        data = new GridData(4, 0x1000000, true, false);
        data.minimumWidth = typeWidth;
        toolBar.setLayoutData((Object)data);
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        this.toolItem.setImage(ImageFactory.getEqualImage());
        final Menu menu = new Menu((Decorations)composite.getShell(), 8);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = QueryEditableHexTableComposite.this.toolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        MenuItem isMenuItem = new MenuItem(menu, 8);
        isMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        isMenuItem.setImage(ImageFactory.getEqualImage());
        isMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditableHexTableComposite.this.setIs(true);
            }
        });
        MenuItem isNotMenuItem = new MenuItem(menu, 8);
        isNotMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        isNotMenuItem.setImage(ImageFactory.getNotEqualImage());
        isNotMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditableHexTableComposite.this.setIs(false);
            }
        });
        data = new GridData(4, 4, true, true);
        if (this.hasEquivalentColumns()) {
            List equivalentColumns = this.getEquivalentColumns();
            final Composite c = new Composite(composite, 0);
            GridData data2 = new GridData(4, 0x1000000, true, false);
            c.setLayout((Layout)new GridLayout(2, false));
            c.setLayoutData((Object)data2);
            this.columnButton = new Button(c, 16);
            data2 = new GridData(16384, 0x1000000, false, false);
            this.columnButton.setLayoutData((Object)data2);
            if (equivalentColumns.size() == 1) {
                String column;
                this.selectedColumn = column = (String)equivalentColumns.get(0);
                Label columnButtonLabel = new Label(c, 0);
                columnButtonLabel.setText(SQLDefinitions.getColumnDescription((String)column));
                this.columnButton.setData((Object)column);
            } else {
                this.columnToolBar = new ToolBar(c, 0x800000);
                data2 = new GridData(16384, 4, true, false);
                this.columnToolBar.setLayoutData((Object)data2);
                this.columnToolItem = new ToolItem(this.columnToolBar, 4);
                this.columnToolItem.setToolTipText(Messages.getString("QueryEditableTableComposite.columnLabel.text"));
                this.columnToolItem.setText(SQLDefinitions.getColumnDescription((String)((String)equivalentColumns.get(0))));
                this.columnMenu = new Menu((Decorations)c.getShell(), 8);
                this.columnToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Rectangle rect = QueryEditableHexTableComposite.this.columnToolItem.getBounds();
                        Point pt = new Point(rect.x, rect.y + rect.height);
                        pt = c.toDisplay(pt);
                        QueryEditableHexTableComposite.this.columnMenu.setLocation(pt.x, pt.y);
                        QueryEditableHexTableComposite.this.columnMenu.setVisible(true);
                    }
                });
                for (String column : equivalentColumns) {
                    final MenuItem menuItem = new MenuItem(this.columnMenu, 8);
                    menuItem.setText(SQLDefinitions.getColumnDescription((String)column));
                    menuItem.setData((Object)column);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ClauseGroup clauses;
                            Clause clause;
                            QueryEditableHexTableComposite.this.selectedColumn = (String)menuItem.getData();
                            QueryEditableHexTableComposite.this.columnToolItem.setText(menuItem.getText());
                            QueryEditableHexTableComposite.this.columnToolBar.pack();
                            QueryEditableHexTableComposite.this.columnToolBar.layout();
                            QueryEditableHexTableComposite.this.columnToolBar.getParent().layout(true);
                            QueryEditableHexTableComposite.this.columnButton.setSelection(true);
                            QueryEditableHexTableComposite.this.tableButton.setSelection(false);
                            QueryEditableHexTableComposite.this.setTableEnablement(false);
                            boolean is = false;
                            is = QueryEditableHexTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableHexTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableHexTableComposite.this.constraint).getClauses().get(0)).isNot();
                            QueryEditableHexTableComposite.this.recalculateFromSelection(QueryEditableHexTableComposite.this.selectedColumn, is);
                        }
                    });
                }
            }
            this.columnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryEditableHexTableComposite.this.columnButton.getSelection()) {
                        ClauseGroup clauses;
                        Clause clause;
                        boolean is = false;
                        is = QueryEditableHexTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableHexTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableHexTableComposite.this.constraint).getClauses().get(0)).isNot();
                        QueryEditableHexTableComposite.this.recalculateFromSelection(QueryEditableHexTableComposite.this.selectedColumn, is);
                        QueryEditableHexTableComposite.this.setTableEnablement(false);
                    }
                }
            });
            this.tableButton = new Button(c, 16);
            Label tableButtonLabel = new Label(c, 0);
            tableButtonLabel.setText(Messages.getString("QueryEditableTableComposite.tableButtonLabel.text"));
            this.tableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryEditableHexTableComposite.this.tableButton.getSelection()) {
                        ClauseGroup clauses;
                        Clause clause;
                        boolean is = false;
                        is = QueryEditableHexTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableHexTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableHexTableComposite.this.constraint).getClauses().get(0)).isNot();
                        QueryEditableHexTableComposite.this.recalculateFromEditableTable(QueryEditableHexTableComposite.this.programTable, is);
                        QueryEditableHexTableComposite.this.setTableEnablement(true);
                    }
                }
            });
            data.horizontalIndent = 20;
        }
        this.programTable = new Table(composite, 2052);
        this.programTable.setLayoutData((Object)data);
        this.programTable.setLinesVisible(true);
        final TableColumn column = new TableColumn(this.programTable, 0);
        column.setWidth(this.programTable.getSize().x);
        this.programTable.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle area = QueryEditableHexTableComposite.this.programTable.getClientArea();
                column.setWidth(area.width);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return composite;
    }

    private ColumnReference getColumnReference() {
        ColumnReference column = null;
        if (this.constraint instanceof Clause) {
            column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        } else {
            ClauseGroup clauses = (ClauseGroup)this.constraint;
            Clause clause = (Clause)clauses.getClauses().get(0);
            column = (ColumnReference)clause.getColumns().get(0);
        }
        return column;
    }

    protected void recalculateFromSelection(String selection, boolean is) {
        ColumnReference column = this.getColumnReference();
        column.setType(ColumnReference.DataType.Column);
        column.setDirection(Direction.ASC);
        Clause newClause = null;
        Object[] values = new Object[]{selection};
        newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, values, !is);
        this.constraint = newClause;
        this.notifyListeners();
    }

    @Override
    protected void recalculateFromEditableTable(Table aTable, boolean is) {
        ColumnReference column = this.getColumnReference();
        ArrayList<Long> values = new ArrayList<Long>();
        TableItem[] tablesItems = aTable.getItems();
        int i = 0;
        while (i < tablesItems.length) {
            Long value = (Long)tablesItems[i].getData();
            if (value != null) {
                values.add(value);
            }
            ++i;
        }
        if (values.size() > 1) {
            Clause newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.IN, values.toArray(), !is);
            this.constraint = newClause;
        } else if (values.size() == 1) {
            Clause newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, values.toArray(), !is);
            this.constraint = newClause;
        } else if (values.size() == 0) {
            Object[] newValues = new Object[]{""};
            Clause newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, newValues, !is);
            this.constraint = newClause;
        }
        this.notifyListeners();
    }

    protected void setTableEnablement(boolean b) {
        this.programTable.setEnabled(b);
        Iterator iterator = this.tableTextItems.iterator();
        while (iterator.hasNext()) {
            ((Text)iterator.next()).setEnabled(b);
        }
    }

    private void setIs(boolean b) {
        String menuText = b ? Messages.getString("QueryEditableTableComposite.QueryEditableTableComposite.button.is") : Messages.getString("QueryEditableTableComposite.QueryEditableTableComposite.button.isnot");
        this.toolItem.setText(menuText);
        Image image = b ? ImageFactory.getEqualImage() : ImageFactory.getNotEqualImage();
        this.toolItem.setImage(image);
        if (this.programTable.isEnabled()) {
            this.recalculateFromEditableTable(this.programTable, b);
        } else {
            this.recalculateFromSelection(this.selectedColumn, b);
        }
    }

    @Override
    public void initialize() {
        ClauseGroup clauses;
        Clause clause;
        this.tableTextItems.clear();
        TableItem[] tableItems = this.programTable.getItems();
        if (this.columnButton != null && this.tableButton != null) {
            this.columnButton.setSelection(false);
            this.tableButton.setSelection(true);
        }
        int i = 0;
        while (i < tableItems.length) {
            ((Text)tableItems[i].getData(TEXT_CONTROL)).dispose();
            tableItems[i].dispose();
            ++i;
        }
        if (this.constraint instanceof Clause) {
            Clause clause2 = (Clause)this.constraint;
            ColumnReference column = (ColumnReference)clause2.getColumns().get(0);
            if (column.getType().equals((Object)ColumnReference.DataType.Column)) {
                int numberOfItems;
                MenuItem menuItem;
                List valuesList = clause2.getValues();
                Values values = (Values)valuesList.get(0);
                Object value = values.getValue();
                if (this.columnButton != null && this.tableButton != null) {
                    this.columnButton.setSelection(true);
                    this.tableButton.setSelection(false);
                }
                this.selectedColumn = (String)value;
                if (this.columnMenu != null && (menuItem = (MenuItem)this.columnMenu.getData(this.selectedColumn)) != null) {
                    this.columnToolItem.setText(menuItem.getText());
                    this.columnToolBar.pack();
                    this.columnToolBar.layout();
                    this.columnToolBar.getParent().layout(true);
                }
                if ((numberOfItems = this.programTable.getItemCount()) == 0) {
                    this.createTableItem(0L);
                }
                int i2 = ++numberOfItems;
                while (i2 < 25) {
                    this.createTableItem(null);
                    ++i2;
                }
                this.setTableEnablement(false);
            } else {
                if (this.columnButton != null && this.tableButton != null) {
                    this.columnButton.setSelection(false);
                    this.tableButton.setSelection(true);
                }
                this.createTableItems(clause2);
            }
        } else {
            List constraints = ((ClauseGroup)this.constraint).getClauses();
            for (ConstraintElement element : constraints) {
                if (!(element instanceof Clause)) continue;
                Clause clause3 = (Clause)this.constraint;
                ColumnReference column = (ColumnReference)clause3.getColumns().get(0);
                if (column.getType().equals((Object)ColumnReference.DataType.Column)) {
                    MenuItem menuItem;
                    List valuesList = clause3.getValues();
                    Values values = (Values)valuesList.get(0);
                    Object value = values.getValue();
                    if (this.columnButton != null && this.tableButton != null) {
                        this.columnButton.setSelection(true);
                        this.tableButton.setSelection(false);
                    }
                    this.selectedColumn = (String)value;
                    if (this.columnMenu != null && (menuItem = (MenuItem)this.columnMenu.getData(this.selectedColumn)) != null) {
                        this.columnToolItem.setText(menuItem.getText());
                        this.columnToolBar.pack();
                        this.columnToolBar.layout();
                        this.columnToolBar.getParent().layout(true);
                    }
                    this.setTableEnablement(false);
                    continue;
                }
                this.createTableItems(clause3);
            }
        }
        if (this.programTable.isEnabled()) {
            int numberOfItems = this.programTable.getItemCount();
            if (numberOfItems == 0) {
                this.createTableItem(0L);
            }
            int i3 = ++numberOfItems;
            while (i3 < 25) {
                this.createTableItem(null);
                ++i3;
            }
        }
        boolean is = false;
        is = this.constraint instanceof Clause ? !(clause = (Clause)this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)this.constraint).getClauses().get(0)).isNot();
        this.setIs(is);
    }

    private void createTableItem(Long value) {
        final TableItem newItem = new TableItem(this.programTable, 0);
        if (value != null) {
            if (value == -1L) {
                newItem.setText("FFFFFFFF");
            } else {
                newItem.setText(Long.toHexString(value));
            }
            newItem.setData((Object)value);
        }
        TableEditor tableEditor = new TableEditor(this.programTable);
        tableEditor.grabHorizontal = true;
        final Text programItemText = new Text((Composite)this.programTable, 0);
        EnsureUppercaseListener.attach((Text)programItemText);
        programItemText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (QueryEditableHexTableComposite.this.isPrintableChar(e.character) && Character.digit(e.character, 16) == -1) {
                    e.doit = false;
                    return;
                }
                super.keyPressed(e);
            }
        });
        programItemText.setData(TABLE_ITEM, (Object)newItem);
        if (value != null) {
            if (value == -1L) {
                programItemText.setText("FFFFFFFF");
            } else {
                programItemText.setText(Long.toHexString(value));
            }
            programItemText.setData((Object)value);
        }
        newItem.setData(TEXT_CONTROL, (Object)programItemText);
        tableEditor.setEditor((Control)programItemText, newItem, 0);
        programItemText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClauseGroup clauses;
                Clause clause;
                long value = 0L;
                try {
                    String text = programItemText.getText();
                    if (text.length() > 8) {
                        Point point = programItemText.getSelection();
                        programItemText.setText(text.substring(0, 8));
                        programItemText.setSelection(point);
                    }
                    value = text.equals("FFFFFFFF") ? -1L : Long.parseLong(programItemText.getText(), 16);
                }
                catch (NumberFormatException text) {
                    // empty catch block
                }
                newItem.setData((Object)value);
                boolean is = false;
                is = QueryEditableHexTableComposite.this.constraint instanceof Clause ? !(clause = (Clause)QueryEditableHexTableComposite.this.constraint).isNot() : !((Clause)(clauses = (ClauseGroup)QueryEditableHexTableComposite.this.constraint).getClauses().get(0)).isNot();
                QueryEditableHexTableComposite.this.recalculateFromEditableTable(QueryEditableHexTableComposite.this.programTable, is);
            }
        });
        this.tableTextItems.add(programItemText);
    }

    public boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '?' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    private void createTableItems(Clause clause) {
        List valuesList = clause.getValues();
        for (Values values : valuesList) {
            Long longValue;
            Object value = values.getValue();
            if (value instanceof String) {
                longValue = Long.parseLong((String)value);
                this.createTableItem(longValue);
                continue;
            }
            if (value instanceof Integer) {
                longValue = (long)((Integer)value);
                this.createTableItem(longValue);
                continue;
            }
            if (!(value instanceof Long)) continue;
            longValue = (Long)value;
            this.createTableItem(longValue);
        }
        this.setTableEnablement(true);
    }
}

