/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.composites.CheckBoxTableLabelProvider;
import com.ibm.cics.ia.ui.composites.ExpressionComposite;
import com.ibm.cics.ia.ui.composites.Messages;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class QueryCheckboxTableComposite
extends ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Table table;
    private Map dataToTableItems;
    private Button columnButton;
    private Button tableButton;
    private ToolItem toolItem;
    private String selectedColumn;

    @Override
    public Composite createComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 1;
        c.setLayout((Layout)gridLayout);
        final ToolBar toolBar = new ToolBar(c, 0x820000);
        GridData data = new GridData(4, 0x1000000, true, false);
        toolBar.setLayoutData((Object)data);
        this.toolItem = new ToolItem(toolBar, 0x800004);
        this.toolItem.setToolTipText(Messages.getString("QueryCheckboxTableComposite.toolItem.toolTipText"));
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        this.toolItem.setImage(ImageFactory.getNotEqualImage());
        int typeWidth = this.toolItem.getBounds().width;
        data = new GridData(4, 0x1000000, true, false);
        data.minimumWidth = typeWidth;
        toolBar.setLayoutData((Object)data);
        this.toolItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        this.toolItem.setImage(ImageFactory.getEqualImage());
        final Menu menu = new Menu((Decorations)c.getShell(), 8);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = QueryCheckboxTableComposite.this.toolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        MenuItem isMenuItem = new MenuItem(menu, 8);
        isMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.is"));
        isMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryCheckboxTableComposite.this.setIs(true);
            }
        });
        isMenuItem.setImage(ImageFactory.getEqualImage());
        MenuItem isNotMenuItem = new MenuItem(menu, 8);
        isNotMenuItem.setText(Messages.getString("QueryCheckboxTableComposite.button.isnot"));
        isNotMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryCheckboxTableComposite.this.setIs(false);
            }
        });
        isNotMenuItem.setImage(ImageFactory.getNotEqualImage());
        data = new GridData(4, 4, true, true);
        if (this.hasEquivalentColumns()) {
            Composite topComposite = new Composite(c, 0);
            topComposite.setLayout((Layout)new GridLayout(1, false));
            this.columnButton = new Button(topComposite, 16);
            List equivalentColumns = this.getEquivalentColumns();
            if (equivalentColumns.size() == 1) {
                String column = (String)equivalentColumns.get(0);
                this.columnButton.setText(SQLDefinitions.getColumnDescription((String)column));
                this.columnButton.setData((Object)column);
            }
            this.columnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryCheckboxTableComposite.this.columnButton.getSelection() && QueryCheckboxTableComposite.this.constraint instanceof Clause) {
                        Clause clause = (Clause)QueryCheckboxTableComposite.this.constraint;
                        QueryCheckboxTableComposite.this.recalculateFromSelection(QueryCheckboxTableComposite.this.getSelectedColumn(), !clause.isNot());
                        QueryCheckboxTableComposite.this.table.setEnabled(false);
                    }
                }
            });
            this.tableButton = new Button(topComposite, 16);
            this.tableButton.setText(Messages.getString("QueryCheckboxTableComposite.tableButton.text"));
            this.tableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (QueryCheckboxTableComposite.this.tableButton.getSelection() && QueryCheckboxTableComposite.this.constraint instanceof Clause) {
                        Clause clause = (Clause)QueryCheckboxTableComposite.this.constraint;
                        QueryCheckboxTableComposite.this.recalculateFromCheckedTable(QueryCheckboxTableComposite.this.table, !clause.isNot());
                        QueryCheckboxTableComposite.this.table.setEnabled(true);
                    }
                }
            });
            data.horizontalIndent = 20;
        }
        TableViewer viewer = new TableViewer(c, 2592);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new CheckBoxTableLabelProvider());
        this.table = viewer.getTable();
        this.table.setLayoutData((Object)data);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QueryCheckboxTableComposite.this.constraint instanceof Clause) {
                    Clause clause = (Clause)QueryCheckboxTableComposite.this.constraint;
                    boolean is = !clause.isNot();
                    QueryCheckboxTableComposite.this.recalculateFromCheckedTable(QueryCheckboxTableComposite.this.table, !clause.isNot());
                }
            }
        });
        this.dataToTableItems = this.createTableItems(viewer);
        return c;
    }

    protected String getSelectedColumn() {
        if (this.getEquivalentColumns().size() == 1) {
            return (String)this.getEquivalentColumns().get(0);
        }
        return null;
    }

    protected void recalculateFromSelection(String selection, boolean is) {
        String fieldName = "";
        ColumnReference column = null;
        if (this.constraint instanceof Clause) {
            column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        } else {
            ClauseGroup clauses = (ClauseGroup)this.constraint;
            Clause clause = (Clause)clauses.getClauses().get(0);
            column = (ColumnReference)clause.getColumns().get(0);
        }
        column.setType(ColumnReference.DataType.Column);
        Object[] values = new Object[]{selection};
        Clause newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, values, !is);
        this.constraint = newClause;
        this.notifyListeners();
    }

    protected abstract Map createTableItems(TableViewer var1);

    @Override
    public void initialize() {
        this.reset();
        this.populateTable(this.dataToTableItems, this.table);
        if (this.constraint instanceof Clause) {
            Clause clause = (Clause)this.constraint;
            boolean is = !clause.isNot();
            this.setIs(is);
        }
    }

    @Override
    public void reset() {
        boolean is = false;
        if (this.constraint instanceof Clause) {
            Clause clause = (Clause)this.constraint;
            is = !clause.isNot();
            ColumnReference column = (ColumnReference)clause.getColumns().get(0);
            if (column.getType().equals((Object)ColumnReference.DataType.Column)) {
                this.tableButton.setSelection(false);
                this.columnButton.setSelection(true);
                List valuesList = clause.getValues();
                Values values = (Values)valuesList.get(0);
                Object value = values.getValue();
                this.selectedColumn = (String)value;
                this.setTableEnablement(false);
            } else {
                Collection values = this.dataToTableItems.values();
                for (TableItem tableItem : values) {
                    tableItem.setChecked(false);
                }
                if (this.hasEquivalentColumns()) {
                    this.tableButton.setSelection(true);
                    this.columnButton.setSelection(false);
                }
                this.setTableEnablement(true);
            }
        }
        this.toolItem.setText(Messages.getString("QueryUsecountComposite.comp.is"));
    }

    protected void setTableEnablement(boolean b) {
        this.table.setEnabled(b);
    }

    private void setIs(boolean b) {
        String menuText = b ? Messages.getString("QueryCheckboxTableComposite.button.is") : Messages.getString("QueryCheckboxTableComposite.button.isnot");
        this.toolItem.setText(menuText);
        Image image = b ? ImageFactory.getEqualImage() : ImageFactory.getNotEqualImage();
        this.toolItem.setImage(image);
        if (this.table.isEnabled()) {
            this.recalculateFromCheckedTable(this.table, b);
        } else {
            this.recalculateFromSelection(this.getSelectedColumn(), b);
        }
    }
}

