/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AtomDefinitions;
import com.ibm.cics.ia.ui.CollectorOptionsEditor;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.composites.ApplicationContextValuesPropertyItem;
import com.ibm.cics.ia.ui.composites.ApplicationInfoPropertyItem;
import com.ibm.cics.ia.ui.composites.ApplicationModePropertyItem;
import com.ibm.cics.ia.ui.composites.ApplidComboPropertyItem;
import com.ibm.cics.ia.ui.composites.GenericPropertyItem;
import com.ibm.cics.ia.ui.composites.JournalCCComboPropertyItem;
import com.ibm.cics.ia.ui.composites.ReadOnlyPropertyItem;
import com.ibm.cics.ia.ui.composites.TextPropertyItem;
import com.ibm.cics.ia.ui.composites.UpcaseTextPropertyItem;
import com.ibm.cics.ia.ui.composites.YesNoPropertyItem;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PropertyFieldFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Logger logger = Logger.getLogger(PropertyFieldFactory.class.getPackage().getName());
    public static final String COMM_INCLUDE_LIST_CATEGORY = "CollectorOptionsEditor.CommandIncludeList.Category";
    private Tree parentTree = null;
    private CollectorOptionsEditor editor = null;
    private HashMap classes = new HashMap();
    private HashMap composites = new HashMap();
    private HashMap categories = new HashMap();
    private HashMap categoryItems = new HashMap();

    public PropertyFieldFactory(Tree parentTree, CollectorOptionsEditor editor) {
        this.parentTree = parentTree;
        this.editor = editor;
        this.init();
    }

    public void init() {
        this.classes.put("nameid", ReadOnlyPropertyItem.class);
        this.classes.put("state", ReadOnlyPropertyItem.class);
        this.classes.put("datestart", ReadOnlyPropertyItem.class);
        this.classes.put("timestart", ReadOnlyPropertyItem.class);
        this.classes.put("datestop", ReadOnlyPropertyItem.class);
        this.classes.put("timestop", ReadOnlyPropertyItem.class);
        this.classes.put("cmdflowid", UpcaseTextPropertyItem.class);
        this.classes.put("tuserid", UpcaseTextPropertyItem.class);
        this.classes.put("termid", UpcaseTextPropertyItem.class);
        this.classes.put("max_recs", TextPropertyItem.class);
        this.classes.put("max_task", TextPropertyItem.class);
        this.classes.put("tran_exlist_name", UpcaseTextPropertyItem.class);
        this.classes.put("prog_exlist_name", UpcaseTextPropertyItem.class);
        this.classes.put("authority", ReadOnlyPropertyItem.class);
        this.classes.put("journal", ReadOnlyPropertyItem.class);
        this.classes.put("journalcc", JournalCCComboPropertyItem.class);
        this.classes.put("appl_name", ApplicationInfoPropertyItem.class);
        this.classes.put("appl_mode", ApplicationModePropertyItem.class);
        this.classes.put("appl_ctxt", ApplicationContextValuesPropertyItem.class);
        this.classes.put("tran1", UpcaseTextPropertyItem.class);
        this.classes.put("tran2", UpcaseTextPropertyItem.class);
        this.classes.put("tran3", UpcaseTextPropertyItem.class);
        this.classes.put("tran4", UpcaseTextPropertyItem.class);
        this.classes.put("tran5", UpcaseTextPropertyItem.class);
        this.classes.put("comm_inlist_name", UpcaseTextPropertyItem.class);
        this.classes.put("kcics", YesNoPropertyItem.class);
        this.classes.put("kyims", YesNoPropertyItem.class);
        this.classes.put("keymq", YesNoPropertyItem.class);
        this.classes.put("kydb2", YesNoPropertyItem.class);
        this.classes.put("kynat", YesNoPropertyItem.class);
        this.classes.put("exitname", UpcaseTextPropertyItem.class);
        this.classes.put("dcall", YesNoPropertyItem.class);
        this.classes.put("applcode", ReadOnlyPropertyItem.class);
        String[] stringArray = AtomDefinitions.CMDFLOW_APPLIDS;
        int n = AtomDefinitions.CMDFLOW_APPLIDS.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.classes.put(id, ApplidComboPropertyItem.class);
            this.categories.put(id, "CollectorOptionsEditor.Applids.Category");
            ++n2;
        }
        this.categories.put("nameid", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("state", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("datestart", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("timestart", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("datestop", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("timestop", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("cmdflowid", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("tuserid", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("termid", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("max_recs", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("max_task", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("tran_exlist_name", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("prog_exlist_name", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("authority", "CollectorOptionsEditor.CommandFlow.Category");
        this.categories.put("journal", "CollectorOptionsEditor.Journal.Category");
        this.categories.put("journalcc", "CollectorOptionsEditor.Journal.Category");
        this.categories.put("appl_name", "CollectorOptionsEditor.Application.Category");
        this.categories.put("appl_mode", "CollectorOptionsEditor.Application.Category");
        this.categories.put("appl_ctxt", "CollectorOptionsEditor.Application.Category");
        this.categories.put("tran1", "CollectorOptionsEditor.TransactionList.Category");
        this.categories.put("tran2", "CollectorOptionsEditor.TransactionList.Category");
        this.categories.put("tran3", "CollectorOptionsEditor.TransactionList.Category");
        this.categories.put("tran4", "CollectorOptionsEditor.TransactionList.Category");
        this.categories.put("tran5", "CollectorOptionsEditor.TransactionList.Category");
        this.categories.put("comm_inlist_name", COMM_INCLUDE_LIST_CATEGORY);
        this.categories.put("kcics", COMM_INCLUDE_LIST_CATEGORY);
        this.categories.put("kyims", COMM_INCLUDE_LIST_CATEGORY);
        this.categories.put("keymq", COMM_INCLUDE_LIST_CATEGORY);
        this.categories.put("kydb2", COMM_INCLUDE_LIST_CATEGORY);
        this.categories.put("kynat", COMM_INCLUDE_LIST_CATEGORY);
        this.categories.put("exitname", "CollectorOptionsEditor.Misc.Category");
        this.categories.put("dcall", "CollectorOptionsEditor.Misc.Category");
        this.categories.put("applcode", "CollectorOptionsEditor.Misc.Category");
    }

    public GenericPropertyItem getPropertyField(String fieldKey, boolean create) {
        TreeItem categoryItem;
        GenericPropertyItem result = (GenericPropertyItem)this.composites.get(fieldKey);
        if (!create) {
            return result;
        }
        String category = (String)this.categories.get(fieldKey);
        if (category == null) {
            category = "CollectorOptionsEditor.Misc.Category";
            this.categories.put(fieldKey, category);
        }
        if ((categoryItem = (TreeItem)this.categoryItems.get(category)) == null || categoryItem.isDisposed()) {
            categoryItem = new TreeItem(this.parentTree, 0);
            categoryItem.setText(Messages.getString(category));
            categoryItem.setData((Object)category);
            this.categoryItems.put(category, categoryItem);
        }
        if (result == null) {
            Class<ReadOnlyPropertyItem> propertyClass = (Class<ReadOnlyPropertyItem>)this.classes.get(fieldKey);
            if (propertyClass == null) {
                propertyClass = ReadOnlyPropertyItem.class;
            }
            try {
                result = (GenericPropertyItem)propertyClass.getDeclaredConstructor(TreeItem.class, CollectorOptionsEditor.class, String.class, String.class).newInstance(new Object[]{categoryItem, this.editor, fieldKey, Messages.getString("CollectorOptionsEditor.Property." + fieldKey)});
                this.composites.put(fieldKey, result);
            }
            catch (Exception ex) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"getPropertyField", (Throwable)ex);
            }
        }
        return result;
    }

    public void removeComposite(String fieldKey) {
        this.composites.remove(fieldKey);
    }
}

