/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.composites;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class ExpressionComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ConstraintElement constraint;
    protected List listeners = new ArrayList();
    private Composite composite;
    protected String tableType;

    public abstract Composite createComposite(Composite var1);

    public final void setComposite(Composite aComposite) {
        this.composite = aComposite;
    }

    public final Composite getComposite() {
        return this.composite;
    }

    protected void notifyListeners() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((Listener)iter.next()).expressionChanged(this.constraint);
        }
    }

    public abstract void initialize();

    public final void setExpression(ConstraintElement aConstraint) {
        this.constraint = aConstraint;
    }

    public ConstraintElement getExpression() {
        return this.constraint;
    }

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void removeListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    private ColumnReference getColumnReference() {
        ColumnReference column = null;
        if (this.constraint instanceof Clause) {
            column = (ColumnReference)((Clause)this.constraint).getColumns().get(0);
        } else {
            ClauseGroup clauses = (ClauseGroup)this.constraint;
            Clause clause = (Clause)clauses.getClauses().get(0);
            column = (ColumnReference)clause.getColumns().get(0);
        }
        return column;
    }

    protected void recalculateFromCheckedTable(Table aTable, boolean is) {
        String fieldName = "";
        ColumnReference column = this.getColumnReference();
        ArrayList<Object> types = new ArrayList<Object>();
        TableItem[] tableItems = aTable.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem item = tableItems[i];
            if (item.getChecked()) {
                types.add(item.getData());
            }
            ++i;
        }
        if (column.getType().equals((Object)ColumnReference.DataType.Column)) {
            column.setType(ColumnReference.DataType.String);
        }
        Clause newClause = null;
        if (types.size() == 1) {
            newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, types.toArray(), !is);
        } else if (types.size() > 1) {
            newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.IN, types.toArray(), !is);
        } else if (types.size() == 0) {
            Object[] newValues = new Object[]{""};
            newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, newValues, !is);
        }
        this.constraint = newClause;
        this.notifyListeners();
    }

    protected void recalculateFromEditableTable(Table aTable, boolean is) {
        Clause newClause;
        String fieldName = "";
        ColumnReference column = this.getColumnReference();
        if (column.getType().equals((Object)ColumnReference.DataType.Column)) {
            column.setType(ColumnReference.DataType.String);
        }
        ArrayList<String> values = new ArrayList<String>();
        TableItem[] tablesItems = aTable.getItems();
        int i = 0;
        while (i < tablesItems.length) {
            String value = (String)tablesItems[i].getData();
            if (IAUtilities.hasContent((String)value)) {
                values.add(value);
            }
            ++i;
        }
        if (values.size() > 1) {
            Selection selection = PresentationFactory.getInstance().createSelectAllForTable("", "");
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Comparator comparator = Comparator.LI;
                Object next = iter.next();
                if (!IAUtilities.containsWildcard((String)((String)next))) {
                    comparator = Comparator.EQ;
                }
                Clause nextClause = PresentationFactory.getInstance().createSimpleCondition(column, comparator, new Object[]{next}, !is);
                selection.appendCondition((ConstraintElement)nextClause, QueryElement.Predicate.OR);
            }
            this.constraint = selection.getCondition();
        } else if (values.size() == 1) {
            if (IAUtilities.hasContent((String)((String)values.get(0)))) {
                Comparator comparator = Comparator.LI;
                if (!IAUtilities.containsWildcard((String)((String)values.get(0)))) {
                    comparator = Comparator.EQ;
                }
                newClause = PresentationFactory.getInstance().createSimpleCondition(column, comparator, values.toArray(), !is);
                this.constraint = newClause;
            }
        } else if (values.size() == 0) {
            Object[] newValues = new Object[]{""};
            newClause = PresentationFactory.getInstance().createSimpleCondition(column, Comparator.EQ, newValues, !is);
            this.constraint = newClause;
        }
        this.notifyListeners();
    }

    protected void populateTable(Map dataToTableItem, Table aTable) {
        if (this.constraint instanceof Clause) {
            Clause clause = (Clause)this.constraint;
            this.populateTable(dataToTableItem, aTable, clause);
        } else {
            List constraints = ((ClauseGroup)this.constraint).getClauses();
            for (ConstraintElement element : constraints) {
                if (!(element instanceof Clause)) continue;
                Clause clause = (Clause)element;
                this.populateTable(dataToTableItem, aTable, clause);
            }
        }
    }

    private void populateTable(Map dataToTableItem, Table aTable, Clause clause) {
        if (clause.getComparator().equals((Object)Comparator.EQ)) {
            TableItem tableItem;
            List valuesList = clause.getValues();
            Values values = (Values)valuesList.get(0);
            Object value = values.getValue();
            if (value instanceof String && (tableItem = (TableItem)dataToTableItem.get(value)) != null) {
                tableItem.setChecked(true);
                aTable.showItem(tableItem);
            }
        } else if (clause.getComparator().equals((Object)Comparator.IN)) {
            boolean hasFoundItem = false;
            List valuesList = clause.getValues();
            for (Values values : valuesList) {
                Object value = values.getValue();
                TableItem tableItem = (TableItem)dataToTableItem.get(value);
                if (tableItem == null) continue;
                tableItem.setChecked(true);
                if (hasFoundItem) continue;
                aTable.showItem(tableItem);
                hasFoundItem = true;
            }
        }
    }

    public void reset() {
    }

    protected boolean hasEquivalentColumns() {
        return false;
    }

    protected List getEquivalentColumns() {
        return null;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public static interface Listener {
        public void expressionChanged(ConstraintElement var1);

        public void setError(String var1);
    }
}

